/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.network;

import dmg.cells.network.CellDomainNode;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.util.Args;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopoCell
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(TopoCell.class);
    private final Thread _worker;
    private final Object _infoLock = new Object();
    private long _waitTime = 300000L;
    private int _requestCount;
    private CellDomainNode[] _infoMap;
    public static final String hh_ls = "ls [-l]";
    public static final String hh_set_updatetime = "<seconds>";

    public TopoCell(String cellName, String cellArgs) {
        super(cellName, cellArgs, true);
        String wait = this.getArgs().getOpt("update");
        try {
            this._waitTime = Long.parseLong(wait) * 1000L;
        }
        catch (NumberFormatException ee) {
            // empty catch block
        }
        _log.info("Update set to " + this._waitTime + " millis");
        this._worker = this.getNucleus().newThread(this);
        this._worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Thread.currentThread() == this._worker) {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(this._waitTime);
                        this.setStatus("Starting auto topology detector : " + this._requestCount);
                        CellDomainNode[] info = this.getTopologyMap();
                        this.setStatus("Auto Topology Detector Ready : " + this._requestCount);
                        Object object = this._infoLock;
                        synchronized (object) {
                            this._infoMap = info;
                        }
                        ++this._requestCount;
                    }
                }
                catch (InterruptedException ie) {
                    _log.info("Topology Thread was interrupted");
                }
                catch (Exception e) {
                    _log.warn("Exception in Loop : " + e);
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CellDomainNode[] getInfoMap() {
        CellDomainNode[] info;
        Object object = this._infoLock;
        synchronized (object) {
            info = this._infoMap;
        }
        return info;
    }

    public String ac_ls_$_0(Args args) {
        boolean detail = args.hasOption("l");
        CellDomainNode[] info = this.getInfoMap();
        if (info == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (CellDomainNode node : info) {
            sb.append(node.getName());
            if (detail) {
                sb.append(" ").append(node.getAddress());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private CellDomainNode[] getTopologyMap() throws Exception {
        Vector<CellDomainNode> vec = new Vector<CellDomainNode>();
        HashMap<String, CellDomainNode> hash = new HashMap<String, CellDomainNode>();
        CellDomainNode node = new CellDomainNode(this.getCellDomainName(), "System@" + this.getCellDomainName());
        vec.add(node);
        for (int i = 0; i < vec.size(); ++i) {
            node = (CellDomainNode)vec.get(i);
            String name = node.getName();
            String address = node.getAddress();
            if (hash.get(name) != null) continue;
            hash.put(name, node);
            this.setStatus("Request to : " + address);
            CellTunnelInfo[] infos = this.getCTI(address);
            if (infos == null) {
                this.setStatus("No Answer from : " + address);
                continue;
            }
            this.setStatus("Answer Ok : " + address);
            HashSet<CellTunnelInfo> acceptedTunnels = new HashSet<CellTunnelInfo>();
            for (CellTunnelInfo info : infos) {
                String domain;
                try {
                    domain = info.getRemoteCellDomainInfo().getCellDomainName();
                }
                catch (Exception npe) {
                    _log.warn("Exception in domain info : " + info.toString());
                    continue;
                }
                node = new CellDomainNode(domain, address + ":System@" + domain);
                vec.add(node);
                acceptedTunnels.add(info);
            }
            node.setLinks(acceptedTunnels.toArray(new CellTunnelInfo[acceptedTunnels.size()]));
        }
        CellDomainNode[] nodes = hash.values().toArray(new CellDomainNode[hash.size()]);
        return nodes;
    }

    @Override
    public String toString() {
        return "Run Count : " + this._requestCount;
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("   Topology Cell");
        pw.println(" Request Counter : " + this._requestCount);
        pw.println(" Topology Information  : ");
        CellDomainNode[] infos = this.getInfoMap();
        if (infos != null) {
            for (CellDomainNode anInfo : infos) {
                pw.print(anInfo.toString());
            }
        } else {
            pw.println("    No Information yet");
        }
    }

    private synchronized CellTunnelInfo[] getCTI(String cellPath) throws Exception {
        CellMessage msg = new CellMessage(new CellPath(cellPath), (Serializable)((Object)"getcelltunnelinfos"));
        if ((msg = this.sendAndWait(msg, this._waitTime)) == null) {
            this.setStatus("Timeout from : " + cellPath);
            return null;
        }
        return (CellTunnelInfo[])msg.getMessageObject();
    }

    public Object ac_gettopomap(Args args) {
        return this.getInfoMap();
    }

    public String ac_set_updatetime_$_1(Args args) {
        this._waitTime = (long)Integer.parseInt(args.argv(0)) * 1000L;
        return "Refresh rate set to " + this._waitTime + " mseconds";
    }

    public String ac_show_updatetime(Args args) {
        return "Refresh rate set to " + this._waitTime + " mseconds";
    }

    @Override
    public void cleanUp() {
        this._worker.interrupt();
    }

    private void setStatus(String st) {
        _log.info(st);
    }
}

