/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.network;

import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellDomainInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellTunnel;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.ExceptionEvent;
import dmg.cells.nucleus.KillEvent;
import dmg.cells.nucleus.LastMessageEvent;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.RoutedMessageEvent;
import dmg.util.Args;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.dcache.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTunnel
implements Cell,
Runnable,
CellTunnel {
    private static final Logger _log = LoggerFactory.getLogger(SimpleTunnel.class);
    private CellNucleus _nucleus;
    private Thread _senderThread;
    private Thread _receiverThread;
    private Thread _connectorThread;
    private ObjectInputStream _input;
    private ObjectOutputStream _output;
    private Socket _socket;
    private String _state = "Not Initialized";
    private String _mode = "None";
    private CellRoute _route;
    private boolean _ready;
    private final Object _readyLock = new Object();
    private CellDomainInfo _remoteDomainInfo;
    private final Version version = Version.of((Object)this);

    public SimpleTunnel(String cellName, String argString) throws Exception {
        Args args = new Args(argString);
        if (args.argc() < 2) {
            throw new IllegalArgumentException("Wrong Usage");
        }
        this._SimpleTunnel(cellName, args.argv(0), new Integer(args.argv(1)));
    }

    public SimpleTunnel(String cellName, String host, int port) throws Exception {
        this._SimpleTunnel(cellName, host, port);
    }

    private void _SimpleTunnel(String cellName, String host, int port) throws Exception {
        InetAddress address = InetAddress.getByName(host);
        this._socket = new Socket(address, port);
        this._mode = "Connection";
        this._nucleus = new CellNucleus(this, cellName);
        this._connectorThread = this._nucleus.newThread(this, "Connector");
        this._connectorThread.start();
    }

    public SimpleTunnel(String cellName, Socket socket) {
        this._mode = "Acception";
        this._nucleus = new CellNucleus(this, cellName);
        this._socket = socket;
        this._connectorThread = this._nucleus.newThread(this, "Connector");
        this._connectorThread.start();
    }

    @Override
    public CellTunnelInfo getCellTunnelInfo() {
        return new CellTunnelInfo(this._nucleus.getCellName(), new CellDomainInfo(this._nucleus.getCellDomainName()), this._remoteDomainInfo);
    }

    private void _connector() throws Exception {
        this._output.writeObject(new CellDomainInfo(this._nucleus.getCellDomainName()));
        Object obj = this._input.readObject();
        if (obj == null) {
            throw new IOException("Premature EOS encountered");
        }
        this._remoteDomainInfo = (CellDomainInfo)obj;
    }

    private void _acceptor() throws Exception {
        this._output.writeObject(new CellDomainInfo(this._nucleus.getCellDomainName()));
        Object obj = this._input.readObject();
        if (obj == null) {
            throw new IOException("Premature EOS encountered");
        }
        this._remoteDomainInfo = (CellDomainInfo)obj;
    }

    private void _makeStreams() throws IOException {
        this._output = new ObjectOutputStream(this._socket.getOutputStream());
        if (this._output == null) {
            throw new IOException("OutputStream == null");
        }
        this._input = new ObjectInputStream(this._socket.getInputStream());
        if (this._input == null) {
            this._output.close();
            throw new IOException("InputStream == null");
        }
    }

    @Override
    public void run() {
        block16: {
            if (Thread.currentThread() == this._connectorThread) {
                this._state = "Initializing";
                try {
                    _log.info("Creating Streams in " + this._mode + " Mode");
                    this._makeStreams();
                    _log.info("Streams created");
                    _log.info("Running " + this._mode + " Protocol");
                    if (this._mode.equals("Acception")) {
                        this._acceptor();
                    } else {
                        this._connector();
                    }
                    _log.info("Protocol ready (" + this._remoteDomainInfo + ")");
                }
                catch (Exception nse) {
                    _log.info(" Problem in Initial Protocol : " + nse);
                    try {
                        this._socket.close();
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                    this._nucleus.kill();
                    return;
                }
                _log.info("Starting I/O threads ");
                this._receiverThread = this._nucleus.newThread(this, "Receiver");
                this._receiverThread.start();
                this._senderThread = this._nucleus.newThread(this, "Sender");
                this._senderThread.start();
                this._route = new CellRoute(this._remoteDomainInfo.getCellDomainName(), this._nucleus.getCellName(), 3);
                _log.info("Route added : " + this._route);
                this._nucleus.routeAdd(this._route);
                this._state = "Active";
            } else {
                if (Thread.currentThread() == this._receiverThread) {
                    block8: while (true) {
                        try {
                            Object obj;
                            while ((obj = this._input.readObject()) != null) {
                                CellMessage msg = (CellMessage)obj;
                                _log.info(" Message from tunnel : " + msg);
                                try {
                                    this._nucleus.sendMessage(msg);
                                    continue block8;
                                }
                                catch (NoRouteToCellException nrtce) {
                                    _log.info("Exception while resending message : " + nrtce);
                                }
                            }
                            break block16;
                        }
                        catch (Exception ioe) {
                            _log.info("Exception while receiving message : " + ioe);
                            this._nucleus.kill();
                            break block16;
                        }
                    }
                }
                if (Thread.currentThread() == this._senderThread) {
                    // empty if block
                }
            }
        }
    }

    public String toString() {
        if (this._remoteDomainInfo == null) {
            return "M=" + this._mode + ";S=" + this._state;
        }
        return "M=" + this._mode + ";S=" + this._state + ";P=" + this._remoteDomainInfo.getCellDomainName();
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Simple Tunnel : ").append(this._nucleus.getCellName()).append("\n");
        sb.append("Mode          : ").append(this._mode).append("\n");
        sb.append("Status        : ").append(this._state).append("\n");
        if (this._remoteDomainInfo == null) {
            sb.append("Peer          : N.N.\n");
        } else {
            sb.append("Peer          : ").append(this._remoteDomainInfo.getCellDomainName()).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageArrived(MessageEvent me) {
        if (me instanceof RoutedMessageEvent) {
            try {
                CellMessage msg = me.getMessage();
                _log.info("Message tunneling : " + msg);
                this._output.writeObject(msg);
                this._output.flush();
            }
            catch (Exception ioe) {
                _log.info("Exception while sending message : " + ioe);
            }
        } else if (me instanceof LastMessageEvent) {
            _log.info("Got last message ; releasing lock ");
            Object object = this._readyLock;
            synchronized (object) {
                this._ready = true;
                this._readyLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void prepareRemoval(KillEvent ce) {
        this._state = "Removing";
        _log.info("PrepareRemoval initiated" + ce);
        _log.info("PrepareRemoval : removing route");
        if (this._route != null) {
            this._nucleus.routeDelete(this._route);
        }
        this._route = null;
        Object object = this._readyLock;
        synchronized (object) {
            if (!this._ready) {
                _log.info("PrepareRemoval : waiting for last message to be processed");
                try {
                    this._readyLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        _log.info("PrepareRemoval : closing streams");
        try {
            this._input.close();
            this._output.close();
            this._socket.close();
        }
        catch (Exception nsea) {
            _log.info(" Problem in i/o : " + nsea);
        }
        this._state = "Dead";
    }

    @Override
    public void exceptionArrived(ExceptionEvent ce) {
        _log.info(" exceptionArrived " + ce);
    }

    @Override
    public CellVersion getCellVersion() {
        return new CellVersion(this.version);
    }
}

