/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.network;

import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellDomainInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellTunnel;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.cells.nucleus.ExceptionEvent;
import dmg.cells.nucleus.KillEvent;
import dmg.cells.nucleus.LastMessageEvent;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.RoutedMessageEvent;
import dmg.util.Args;
import dmg.util.Gate;
import dmg.util.StreamEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryTunnel2
extends CellAdapter
implements Cell,
Runnable,
CellTunnel {
    private static final Logger _log = LoggerFactory.getLogger(RetryTunnel2.class);
    private String _host;
    private Args _args;
    private int _port;
    private CellNucleus _nucleus;
    private Thread _connectionThread;
    private Thread _ioThread;
    private final Object _routeLock = new Object();
    private final Object _tunnelOkLock = new Object();
    private boolean _tunnelOk;
    private String _mode = "None";
    private String _status = "<init>";
    private CellRoute _route;
    private CellDomainInfo _remoteDomainInfo;
    private StreamEngine _engine;
    private ObjectInputStream _input;
    private ObjectOutputStream _output;
    private Gate _finalGate = new Gate(false);
    private int _connectionRequests;
    private int _messagesToTunnel;
    private int _messagesToSystem;
    private int _connectionRetries;

    public RetryTunnel2(String cellName, StreamEngine engine, Args args) {
        super(cellName, "System", args, true);
        this._engine = engine;
        this._mode = "Accepted";
        this._nucleus = this.getNucleus();
        this._ioThread = this._nucleus.newThread(this, "IoThread");
        this._ioThread.start();
        _log.info("Constructor : acceptor started");
        this._status = "<connected>";
    }

    public RetryTunnel2(String cellName, String argString) {
        super(cellName, "System", argString, false);
        _log.info("CellName : " + cellName + " ; args : " + argString);
        this._args = this.getArgs();
        this._nucleus = this.getNucleus();
        if (this._args.argc() < 2) {
            this.start();
            this.kill();
            throw new IllegalArgumentException("Usage : ... <host> <port>");
        }
        this._RetryTunnel2(cellName, this._args.argv(0), Integer.valueOf(this._args.argv(1)));
        this.start();
    }

    public RetryTunnel2(String cellName, String host, int port) {
        super(cellName, "System", host + " " + port, true);
        this._args = this.getArgs();
        this._RetryTunnel2(cellName, host, port);
    }

    private void _RetryTunnel2(String cellName, String host, int port) {
        this._mode = "Connection";
        this._host = host;
        this._port = port;
        this._connectionThread = this._nucleus.newThread(this, "Connection");
        this._connectionThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runConnection() {
        long start = 0L;
        while (!Thread.interrupted()) {
            _log.info("Trying to connect " + this._host + "(" + this._port + ")");
            this._status = "<connecting-" + this._connectionRetries + ">";
            try {
                ++this._connectionRetries;
                start = System.currentTimeMillis();
                Socket socket = new Socket(this._host, this._port);
                this._makeStreams(socket.getInputStream(), socket.getOutputStream());
                Object object = this._tunnelOkLock;
                synchronized (object) {
                    this._tunnelOk = true;
                }
                this.runIo();
            }
            catch (InterruptedIOException iioe) {
                _log.warn(iioe.toString(), (Throwable)iioe);
                break;
            }
            catch (InterruptedException ie) {
                _log.warn(ie.toString(), (Throwable)ie);
                break;
            }
            catch (Exception ee) {
                _log.warn(ee.toString());
                this.removeRoute();
                Object object = this._tunnelOkLock;
                synchronized (object) {
                    this._tunnelOk = false;
                }
                try {
                    this._output.close();
                }
                catch (Exception ii) {
                    // empty catch block
                }
                try {
                    this._input.close();
                }
                catch (Exception ii) {
                    // empty catch block
                }
                long diff = 30000L - (System.currentTimeMillis() - start);
                diff = diff < 4000L ? 4000L : diff;
                try {
                    _log.info("runConnection : Going to sleep for " + diff / 1000L + " seconds");
                    this._status = "<waiting-" + this._connectionRetries + ">";
                    Thread.sleep(diff);
                }
                catch (InterruptedException ieie) {
                    _log.warn("runConnection : Sleep interrupted");
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runIoThread() {
        try {
            _log.info("runIoThread : creating streams");
            this._status = "<protocol>";
            this._makeStreams(this._engine.getInputStream(), this._engine.getOutputStream());
            _log.info("runIoThread : enabling tunnel");
            Object object = this._tunnelOkLock;
            synchronized (object) {
                this._tunnelOk = true;
            }
            _log.info("runIoThread : starting IO");
            this.runIo();
            this._status = "<io-fin>";
            _log.warn("runIoThread : unknown state 2 ");
        }
        catch (Exception ioe) {
            _log.warn("runIoThread : " + ioe, (Throwable)ioe);
            this._status = "<io-shut>";
            _log.warn("Disabling tunnel");
            Object object = this._tunnelOkLock;
            synchronized (object) {
                this._tunnelOk = false;
            }
            _log.warn("Closing streams");
            try {
                this._output.close();
            }
            catch (IOException ii) {
                // empty catch block
            }
            try {
                this._input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            _log.warn("Killing myself");
            this.kill();
        }
        finally {
            _log.info("runIoThread : finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runIo() throws Exception {
        block7: {
            this._status = "<io>";
            block5: while (true) {
                Object obj;
                while (!Thread.interrupted() && (obj = this._input.readObject()) != null) {
                    CellMessage msg = (CellMessage)obj;
                    _log.info("receiverThread : Message from tunnel : " + msg);
                    try {
                        this.sendMessage(msg);
                        ++this._messagesToSystem;
                        continue block5;
                    }
                    catch (NoRouteToCellException nrtce) {
                        _log.warn(nrtce.toString(), (Throwable)nrtce);
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                this._status = "<io-shutdown>";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageArrived(MessageEvent me) {
        if (me instanceof RoutedMessageEvent) {
            Object object = this._tunnelOkLock;
            synchronized (object) {
                CellMessage msg = me.getMessage();
                if (this._tunnelOk) {
                    _log.info("messageArrived : " + msg);
                    try {
                        this._output.writeObject(msg);
                        this._output.reset();
                        ++this._messagesToTunnel;
                    }
                    catch (IOException ioe) {
                        _log.warn("messageArrived : " + ioe, (Throwable)ioe);
                        this._tunnelOk = false;
                        try {
                            this._output.close();
                        }
                        catch (IOException ii) {
                            // empty catch block
                        }
                        try {
                            this._input.close();
                        }
                        catch (IOException ii) {}
                    }
                } else {
                    _log.warn("Tunnel down : dumping : " + msg);
                }
            }
        }
        if (me instanceof LastMessageEvent) {
            _log.info("messageArrived : opening final gate");
            this._finalGate.open();
        } else {
            _log.warn("messageArrived : dumping junk message " + me);
        }
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this._connectionThread) {
            this.runConnection();
        } else if (Thread.currentThread() == this._ioThread) {
            this.runIoThread();
        }
    }

    @Override
    public CellTunnelInfo getCellTunnelInfo() {
        return new CellTunnelInfo(this._nucleus.getCellName(), new CellDomainInfo(this._nucleus.getCellDomainName()), this._remoteDomainInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _makeStreams(InputStream in, OutputStream out) throws Exception {
        Object obj;
        this._output = new ObjectOutputStream(out);
        if (this._output == null) {
            throw new IOException("OutputStream == null");
        }
        this._input = new ObjectInputStream(in);
        if (this._input == null) {
            try {
                this._output.close();
            }
            catch (IOException ie) {
                // empty catch block
            }
            throw new IOException("InputStream == null");
        }
        try {
            this._output.writeObject(new CellDomainInfo(this._nucleus.getCellDomainName()));
            obj = this._input.readObject();
            if (obj == null) {
                throw new IOException("EOS encountered while reading DomainInfo");
            }
        }
        catch (IOException ieww) {
            try {
                this._output.close();
                this._output = null;
            }
            catch (IOException ie) {
                // empty catch block
            }
            try {
                this._input.close();
                this._input = null;
            }
            catch (IOException ie) {
                // empty catch block
            }
            throw ieww;
        }
        this._remoteDomainInfo = (CellDomainInfo)obj;
        Object object = this._routeLock;
        synchronized (object) {
            this.removeRoute();
            this._route = new CellRoute(this._remoteDomainInfo.getCellDomainName(), this._nucleus.getCellName(), 3);
            _log.info("addingRoute : " + this._route);
            this._nucleus.routeAdd(this._route);
        }
    }

    @Override
    public String toString() {
        if (this._tunnelOk) {
            return this._status + "/" + this._mode + " -> " + (this._remoteDomainInfo == null ? "???" : this._remoteDomainInfo.getCellDomainName());
        }
        return this._status + "/" + this._mode;
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("Simple Tunnel : " + this._nucleus.getCellName());
        pw.println("Mode          : " + this._mode);
        pw.println("Status        : " + this._mode);
        pw.println("con. Requests : " + this._connectionRequests);
        pw.println("con. Retries  : " + this._connectionRetries);
        pw.println("-> Tunnel     : " + this._messagesToTunnel);
        pw.println("-> Domain     : " + this._messagesToSystem);
        if (this._remoteDomainInfo == null) {
            pw.println("Peer          : N.N.");
        } else {
            pw.println("Peer          : " + this._remoteDomainInfo.getCellDomainName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRoute() {
        Object object = this._routeLock;
        synchronized (object) {
            if (this._route != null) {
                _log.info("removeRoute : removing route " + this._route);
                this._nucleus.routeDelete(this._route);
                this._route = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void prepareRemoval(KillEvent ce) {
        this.removeRoute();
        _log.info("Setting tunnel down");
        Object object = this._tunnelOkLock;
        synchronized (object) {
            this._tunnelOk = false;
        }
        try {
            this._input.close();
        }
        catch (IOException ee) {
            // empty catch block
        }
        try {
            this._output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        _log.info("Streams  closed");
        this._finalGate.check();
        _log.info("Gate Opened. Bye Bye");
    }

    @Override
    public void exceptionArrived(ExceptionEvent ce) {
        _log.warn("exceptionArrived : " + ce);
    }
}

