/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.network;

import dmg.cells.network.LocationMgrTunnel;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.login.SshCAuth_Key;
import dmg.protocols.ssh.SshStreamEngine;
import dmg.util.Args;
import dmg.util.DummyStreamEngine;
import dmg.util.StreamEngine;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationManagerConnector
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger((String)"org.dcache.cells.network");
    private final String _domain;
    private final String _lm;
    private final Thread _thread;
    private String _status = "disconnected";
    private int _retries;

    public LocationManagerConnector(String cellName, String args) {
        super(cellName, "System", args, true);
        Args a = this.getArgs();
        this._domain = a.getOpt("domain");
        this._lm = a.getOpt("lm");
        this._thread = this.getNucleus().newThread(this, "TunnelConnector");
        this._thread.start();
    }

    private synchronized void setStatus(String s) {
        this._status = s;
    }

    private synchronized String getStatus() {
        return this._status;
    }

    private String whereIs(String domain) throws IOException, InterruptedException {
        try {
            String query = "where is " + domain;
            CellPath path = new CellPath(this._lm);
            CellMessage reply = this.sendAndWait(new CellMessage(path, (Serializable)((Object)query)), 5000L);
            if (reply == null) {
                throw new IOException("Timeout querying location manager");
            }
            Serializable obj = reply.getMessageObject();
            if (obj == null || !(obj instanceof String)) {
                throw new IOException("Invalid reply from location manager");
            }
            return obj.toString();
        }
        catch (NoRouteToCellException e) {
            throw new IOException("No route to location manager");
        }
    }

    private StreamEngine connect(String domain) throws IOException, InterruptedException {
        this.setStatus("Locating " + domain);
        Args reply = new Args(this.whereIs(domain));
        if (reply.argc() < 3 || !reply.argv(0).equals("location") || !reply.argv(1).equals(domain)) {
            throw new IOException("Invalid reply from location manager: " + reply);
        }
        String[] s = reply.argv(2).split(":");
        if (s.length != 2) {
            throw new IOException("Invalid address: " + reply.argv(2));
        }
        InetSocketAddress address = new InetSocketAddress(s[0], Integer.parseInt(s[1]));
        this.setStatus("Connecting to " + address);
        Socket socket = SocketChannel.open(address).socket();
        socket.setKeepAlive(true);
        String security = reply.getOpt("security");
        if (security == null) {
            _log.info("Using clear text channel");
            return new DummyStreamEngine(socket);
        }
        Args x = new Args(security);
        String prot = x.getOpt("prot");
        if (prot == null) {
            if (x.argc() == 0) {
                socket.close();
                throw new IOException("Not a proper security context \"" + security + "\"");
            }
            prot = x.argv(0);
        }
        if (!prot.equalsIgnoreCase("ssh") && !prot.equalsIgnoreCase("ssh1")) {
            socket.close();
            throw new IOException("Security mode not supported : " + security);
        }
        _log.info("Using encrypted channel");
        try {
            SshCAuth_Key key = new SshCAuth_Key(this.getNucleus(), this.getArgs());
            return new SshStreamEngine(socket, key);
        }
        catch (Exception e) {
            throw new IOException("Failure creating SSH stream engine: " + e.getMessage());
        }
    }

    @Override
    public void run() {
        Args args = this.getArgs();
        String name = this.getCellName() + "*";
        Random random = new Random();
        try {
            while (true) {
                try {
                    ++this._retries;
                    LocationMgrTunnel tunnel = new LocationMgrTunnel(name, this.connect(this._domain), args);
                    this._retries = 0;
                    this.setStatus("Connected");
                    tunnel.join();
                }
                catch (InterruptedIOException e) {
                    throw e;
                }
                catch (IOException e) {
                    _log.warn("Failed to connect to " + this._domain + ": " + e.getMessage());
                }
                this.setStatus("Sleeping");
                long sleep = random.nextInt(26000) + 4000;
                _log.warn("Sleeping " + sleep / 1000L + " seconds");
                Thread.sleep(sleep);
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    @Override
    public String toString() {
        return this.getStatus();
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("Location manager connector : " + this.getCellName());
        pw.println("Status   : " + this.getStatus());
        pw.println("Retries  : " + this._retries);
    }

    @Override
    public void cleanUp() {
        this._thread.interrupt();
    }
}

