/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.network;

import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.ExceptionEvent;
import dmg.cells.nucleus.KillEvent;
import dmg.cells.nucleus.MessageEvent;
import dmg.util.Args;
import dmg.util.Formats;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.dcache.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GNLCell
implements Cell,
Runnable {
    private static final Logger _log = LoggerFactory.getLogger(GNLCell.class);
    private String _cellName;
    private String _cellClass;
    private CellNucleus _nucleus;
    private int _listenPort;
    private ServerSocket _serverSocket;
    private Thread _listenThread;
    private final Version version = Version.of((Object)this);

    public GNLCell(String name, String cellClass, int port) {
        this._GNLCell(name, cellClass, port);
    }

    public GNLCell(String name, String[] args) {
        if (args.length < 2) {
            throw new IllegalArgumentException("Not enought arguments");
        }
        this._GNLCell(name, args[0], new Integer(args[1]));
    }

    public GNLCell(String name, String arg) {
        Args args = new Args(arg);
        if (args.argc() < 2) {
            throw new IllegalArgumentException("Not enought arguments");
        }
        this._GNLCell(name, args.argv(0), new Integer(args.argv(1)));
    }

    private void _GNLCell(String name, String cellClass, int port) {
        this._nucleus = new CellNucleus(this, name);
        this._cellName = name;
        this._cellClass = cellClass;
        this._listenPort = port;
        try {
            this._serverSocket = new ServerSocket(this._listenPort);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Server Socket : " + e.toString());
        }
        this._listenThread = this._nucleus.newThread(this, "Listener");
        this._listenThread.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (Thread.currentThread() != this._listenThread) return;
        while (true) {
            try {
                while (true) {
                    Socket socket = this._serverSocket.accept();
                    _log.info("Cell Listen Socket created ");
                    Cell cell = this._nucleus.createNewCell(this._cellClass, this._cellName + "*", socket, true);
                }
            }
            catch (IOException ioe) {
                _log.info(" ServerSocket Got Exc : " + ioe);
                this._nucleus.kill();
                continue;
            }
            catch (Exception ae) {
                _log.info(" Problem creating " + this._cellClass + " : " + ae);
                continue;
            }
            break;
        }
    }

    public String toString() {
        return "Network Listener Cell (port=" + this._listenPort + ";Class=" + Formats.cutClass(this._cellClass) + ")";
    }

    @Override
    public String getInfo() {
        return this.toString() + "\n";
    }

    @Override
    public void messageArrived(MessageEvent me) {
        _log.info(" messageArrived " + me);
    }

    @Override
    public void prepareRemoval(KillEvent ce) {
        _log.info(" prepareRemoval " + ce);
    }

    @Override
    public void exceptionArrived(ExceptionEvent ce) {
        _log.info(" exceptionArrived " + ce);
    }

    @Override
    public CellVersion getCellVersion() {
        return new CellVersion(this.version);
    }
}

