/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.spy;

import dmg.cells.applets.spy.BorderPanel;
import dmg.cells.applets.spy.CellPanel;
import dmg.cells.applets.spy.CommandPanel;
import dmg.cells.applets.spy.DomainConnection;
import dmg.cells.applets.spy.FrameArrivable;
import dmg.cells.applets.spy.SpyList;
import dmg.cells.network.CellDomainNode;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.services.MessageObjectFrame;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;

class DomainPanel
extends Panel
implements ActionListener,
FrameArrivable,
ItemListener {
    private static final long serialVersionUID = -2086357792768952598L;
    private DomainConnection _connection;
    private Button _updateButton;
    private Button _detailButton;
    private Button _commandButton;
    private SpyList _list;
    private Label _topLabel;
    private CellDomainNode _domainNode;
    private LeftPanel _leftPanel;
    private CellPanel _cellPanel;
    private CommandPanel _commandPanel;
    private CellInfo[] _infos = new CellInfo[0];
    private CardLayout _cards = new CardLayout();
    private Panel _cardPanel;
    private String _cellMode = "cell";
    private boolean _useColor;

    DomainPanel(DomainConnection connection) {
        this._connection = connection;
        boolean bl = this._useColor = System.getProperty("bw") == null;
        if (this._useColor) {
            this.setBackground(Color.red);
        }
        this.setLayout(new BorderLayout());
        this._leftPanel = new LeftPanel();
        this._topLabel = new Label("Domain", 1);
        this._topLabel.setFont(new Font("fixed", 2, 18));
        this.add((Component)this._topLabel, "North");
        this.add((Component)new BorderPanel(this._leftPanel), "West");
        this._cellPanel = new CellPanel(this._connection);
        this._commandPanel = new CommandPanel(this._connection);
        this._cardPanel = new Panel(this._cards);
        this._cardPanel.add((Component)new BorderPanel(this._cellPanel), "cell");
        this._cardPanel.add((Component)new BorderPanel(this._commandPanel), "command");
        this._cards.show(this._cardPanel, "cell");
        this.add((Component)this._cardPanel, "Center");
        this._updateButton.addActionListener(this);
        this._detailButton.addActionListener(this);
        this._commandButton.addActionListener(this);
        this._list.addItemListener(this);
    }

    @Override
    public Insets getInsets() {
        return new Insets(20, 20, 20, 20);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        if (o == this._updateButton) {
            this.updateDomain();
            this._cellPanel.clear();
            this._commandPanel.clear();
        } else if (o == this._detailButton) {
            this._cards.show(this._cardPanel, "cell");
            this._cellMode = "cell";
        } else if (o == this._commandButton) {
            this._cards.show(this._cardPanel, "command");
            this._cellMode = "command";
        }
    }

    @Override
    public void frameArrived(MessageObjectFrame frame) {
        Serializable obj = frame.getObject();
        if (obj instanceof CellInfo[]) {
            this._infos = (CellInfo[])obj;
            this._list.removeAll();
            int systemIndex = -1;
            TreeSet<String> sorted = new TreeSet<String>();
            for (CellInfo cellInfo : this._infos) {
                sorted.add(cellInfo.getCellName());
            }
            Iterator it = sorted.iterator();
            int i = 0;
            while (it.hasNext()) {
                String name = (String)it.next();
                this._list.add(name);
                if (name.equals("System")) {
                    systemIndex = i;
                }
                ++i;
            }
            if (systemIndex > -1) {
                this._cellPanel.showCell(this._infos[systemIndex], this._domainNode.getAddress());
                this._commandPanel.showCell(this._infos[systemIndex], this._domainNode.getAddress() + ":System");
                this._list.select("System");
            }
        }
    }

    public void clear() {
        this._list.removeAll();
        this._cellPanel.clear();
        this._commandPanel.clear();
    }

    public void showDomain(CellDomainNode domainNode) {
        this._topLabel.setText(">>> " + domainNode.getName() + " <<<");
        this._domainNode = domainNode;
        this._cellPanel.clear();
        this._commandPanel.clear();
        this.updateDomain();
    }

    private void updateDomain() {
        if (this._domainNode == null) {
            return;
        }
        this._connection.send(this._domainNode.getAddress(), (Serializable)((Object)"getcellinfos"), this);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        int i;
        ItemSelectable sel = event.getItemSelectable();
        Object[] obj = sel.getSelectedObjects();
        if (obj == null || obj.length == 0) {
            return;
        }
        String cellName = obj[0].toString();
        for (i = 0; i < this._infos.length && !this._infos[i].getCellName().equals(cellName); ++i) {
        }
        if (i == this._infos.length) {
            System.out.println("No more in list : " + cellName);
            return;
        }
        this._cellPanel.showCell(this._infos[i], this._domainNode.getAddress());
        this._commandPanel.showCell(this._infos[i], this._domainNode.getAddress() + ":" + cellName);
        this._cards.show(this._cardPanel, this._cellMode);
    }

    private class LeftPanel
    extends Panel {
        private static final long serialVersionUID = 8626662575716491546L;

        private LeftPanel() {
            super(new BorderLayout());
            DomainPanel.this._list = new SpyList();
            DomainPanel.this._updateButton = new Button("Update Cell List");
            DomainPanel.this._detailButton = new Button("Cell Detail");
            DomainPanel.this._commandButton = new Button("Commander");
            Label label = new Label("Cell List", 1);
            label.setFont(new Font("fixed", 2, 18));
            this.add((Component)label, "North");
            this.add((Component)DomainPanel.this._list, "Center");
            Panel buttonPanel = new Panel(new GridLayout(0, 1));
            buttonPanel.add(DomainPanel.this._updateButton);
            buttonPanel.add(DomainPanel.this._detailButton);
            buttonPanel.add(DomainPanel.this._commandButton);
            this.add((Component)buttonPanel, "South");
            if (DomainPanel.this._useColor) {
                this.setBackground(Color.green);
            }
        }

        @Override
        public Insets getInsets() {
            return new Insets(10, 10, 10, 10);
        }
    }
}

