/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.spy;

import dmg.cells.applets.spy.BorderPanel;
import dmg.cells.applets.spy.DomainConnection;
import dmg.cells.applets.spy.FrameArrivable;
import dmg.cells.applets.spy.SpyCommandRequest;
import dmg.cells.applets.spy.SpyList;
import dmg.cells.network.CellDomainNode;
import dmg.cells.services.MessageObjectFrame;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;

class ContextPanel
extends Panel
implements ActionListener,
FrameArrivable,
ItemListener {
    private static final long serialVersionUID = -5025275864041931726L;
    private DomainConnection _connection;
    private Button _updateButton;
    private Button _writeButton;
    private Button _newContextButton;
    private Button _removeContextButton;
    private Label _topLabel;
    private TextArea _contextText;
    private TextField _contextNameField;
    private SpyList _list;
    private Font _bigFont = new Font("SansSerif", 2, 18);
    private Font _smallFont = new Font("SansSerif", 3, 14);
    private Font _textFont = new Font("Monospaced", 2, 14);
    private CellDomainNode _domainNode;
    private String[] _contextList = new String[0];
    private String _contextName;
    private boolean _useColor;

    ContextPanel(DomainConnection connection) {
        this._connection = connection;
        boolean bl = this._useColor = System.getProperty("bw") == null;
        if (this._useColor) {
            this.setBackground(Color.orange);
        }
        this.setLayout(new BorderLayout());
        this._topLabel = new Label("Context", 1);
        this._topLabel.setFont(this._bigFont);
        this.add((Component)this._topLabel, "North");
        this._updateButton = new Button("Update List");
        this._updateButton.addActionListener(this);
        this._writeButton = new Button("Rewrite");
        this._writeButton.addActionListener(this);
        this._writeButton.setBackground(Color.red);
        Panel buttonPanel = new Panel(new FlowLayout(1));
        this.add((Component)buttonPanel, "South");
        this._contextText = new TextArea();
        this._contextText.setFont(this._textFont);
        this.add((Component)new BorderPanel(this._contextText), "Center");
        Panel leftPanel = new Panel(new BorderLayout());
        this._list = new SpyList();
        this._list.addItemListener(this);
        leftPanel.add((Component)this._list, "Center");
        Panel downPanel = new Panel(new GridLayout(0, 1));
        downPanel.add(this._updateButton);
        downPanel.add(this._writeButton);
        leftPanel.add((Component)new BorderPanel(downPanel), "South");
        this.add((Component)new BorderPanel(leftPanel), "West");
        this._contextNameField = new TextField();
        this._newContextButton = new Button("New Context");
        this._newContextButton.addActionListener(this);
        this._newContextButton.setBackground(Color.red);
        this._removeContextButton = new Button("Remove Context");
        this._removeContextButton.addActionListener(this);
        this._removeContextButton.setBackground(Color.red);
        Panel bottomPanel = new Panel(new BorderLayout());
        bottomPanel.add((Component)this._removeContextButton, "East");
        bottomPanel.add((Component)this._newContextButton, "West");
        bottomPanel.add((Component)this._contextNameField, "Center");
        this.add((Component)bottomPanel, "South");
    }

    @Override
    public Insets getInsets() {
        return new Insets(20, 20, 20, 20);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        if (o == this._updateButton) {
            this.updateDomain();
            this._contextText.setText("");
        } else if (o == this._newContextButton) {
            if (this._domainNode == null) {
                return;
            }
            final String newContextName = this._contextNameField.getText();
            if (newContextName.equals("")) {
                return;
            }
            String req = "set -c context " + newContextName + " " + newContextName;
            this._connection.send(this._domainNode.getAddress(), (Serializable)((Object)req), new FrameArrivable(){

                @Override
                public void frameArrived(MessageObjectFrame frame) {
                    Serializable result = frame.getObject();
                    ContextPanel.this._contextText.setText(result.toString());
                    ContextPanel.this._contextNameField.setText("");
                    if (!(result instanceof Exception)) {
                        ContextPanel.this.updateDomain(new FrameArrivable(){

                            @Override
                            public void frameArrived(MessageObjectFrame frame) {
                                ContextPanel.this.frameArrived(frame);
                                Serializable res = frame.getObject();
                                if (res instanceof Exception) {
                                    ContextPanel.this._contextText.setText(res.toString());
                                } else {
                                    ContextPanel.this.updateDomain(newContextName);
                                    ContextPanel.this._list.select(newContextName);
                                }
                            }
                        });
                    }
                }
            });
        } else if (o == this._removeContextButton) {
            if (this._domainNode == null || this._contextName == null) {
                return;
            }
            String req = "unset context " + this._contextName;
            this._connection.send(this._domainNode.getAddress(), (Serializable)((Object)req), new FrameArrivable(){

                @Override
                public void frameArrived(MessageObjectFrame frame) {
                    ContextPanel.this._contextText.setText(frame.getObject().toString());
                    ContextPanel.this.updateDomain();
                }
            });
        } else if (o == this._writeButton) {
            if (this._domainNode == null || this._contextName == null) {
                return;
            }
            SpyCommandRequest req = new SpyCommandRequest("set context", this._contextName, this._contextText.getText());
            this._connection.send(this._domainNode.getAddress(), req, this);
        }
    }

    @Override
    public void frameArrived(MessageObjectFrame frame) {
        Serializable obj = frame.getObject();
        if (obj instanceof String[]) {
            this._contextList = (String[])obj;
            this._list.removeAll();
            for (String contextElement : this._contextList) {
                this._list.add(contextElement);
            }
            this._contextText.setText("");
        } else if (obj instanceof Object[]) {
            this._list.select(((Object[])obj)[0].toString());
            this._contextText.setText(((Object[])obj)[1].toString());
        } else {
            this._contextText.setText(obj.toString());
        }
    }

    private void updateDomain() {
        this.updateDomain(this);
    }

    private void updateDomain(FrameArrivable listener) {
        if (this._domainNode == null) {
            return;
        }
        this._contextText.setText("");
        this._contextName = null;
        this._updateButton.setEnabled(true);
        this._newContextButton.setEnabled(true);
        this._writeButton.setEnabled(false);
        this._removeContextButton.setEnabled(false);
        this._connection.send(this._domainNode.getAddress(), (Serializable)((Object)"getcontext"), listener);
    }

    private void updateDomain(String contextName) {
        if (this._domainNode == null) {
            return;
        }
        this._connection.send(this._domainNode.getAddress(), (Serializable)((Object)("getcontext " + contextName)), this);
        this._contextName = contextName;
        this._writeButton.setEnabled(true);
        this._removeContextButton.setEnabled(true);
    }

    public void clear() {
        this._topLabel.setText("<Context>");
        this._list.removeAll();
        this._contextText.setText("");
        this._contextName = null;
        this.setEnabled(false);
    }

    @Override
    public void setEnabled(boolean enable) {
        this._updateButton.setEnabled(enable);
        this._writeButton.setEnabled(enable);
        this._newContextButton.setEnabled(enable);
        this._removeContextButton.setEnabled(enable);
    }

    public void showDomain(CellDomainNode domainNode) {
        this._topLabel.setText(" Context of " + domainNode.getName());
        this._domainNode = domainNode;
        this.updateDomain();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        ItemSelectable sel = event.getItemSelectable();
        Object[] obj = sel.getSelectedObjects();
        if (obj == null || obj.length == 0) {
            return;
        }
        String contextName = obj[0].toString();
        this.updateDomain(contextName);
    }
}

