/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.spy;

import dmg.cells.applets.spy.DomainConnection;
import dmg.cells.applets.spy.FrameArrivable;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.services.MessageObjectFrame;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;

class CellPanel
extends Panel
implements ActionListener,
FrameArrivable {
    private static final long serialVersionUID = -1215043667501349548L;
    private DomainConnection _connection;
    private Button _updateButton;
    private Label _topLabel;
    private Font _bigFont = new Font("SansSerif", 2, 18);
    private Font _smallFont = new Font("SansSerif", 3, 14);
    private Font _textFont = new Font("Monospaced", 1, 14);
    private Label _classLabel;
    private Label _shortInfoLabel;
    private TextArea _privateInfo;
    private CellInfo _cellInfo;
    private String _cellAddress;
    private boolean _useColor = System.getProperty("bw") == null;

    CellPanel(DomainConnection connection) {
        this._connection = connection;
        if (this._useColor) {
            this.setBackground(Color.orange);
        }
        this.setLayout(new BorderLayout());
        this._topLabel = new Label("<Cell>", 1);
        this._topLabel.setFont(this._bigFont);
        this._updateButton = new Button("Update This Cell");
        this._updateButton.addActionListener(this);
        this._classLabel = new Label("");
        this._classLabel.setFont(this._smallFont);
        this._shortInfoLabel = new Label("");
        this._shortInfoLabel.setFont(this._smallFont);
        this._privateInfo = new TextArea();
        this._privateInfo.setFont(this._textFont);
        Panel labelPanel = new Panel(new GridLayout(0, 1));
        labelPanel.add(this._topLabel);
        labelPanel.add(this._classLabel);
        labelPanel.add(this._shortInfoLabel);
        Panel buttonPanel = new Panel(new FlowLayout());
        buttonPanel.add(this._updateButton);
        this.add((Component)labelPanel, "North");
        this.add((Component)this._privateInfo, "Center");
        this.add((Component)buttonPanel, "South");
    }

    public void clear() {
        this._classLabel.setText("");
        this._shortInfoLabel.setText("");
        this._privateInfo.setText("");
        this._topLabel.setText("<className>");
    }

    @Override
    public Insets getInsets() {
        return new Insets(10, 10, 10, 10);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this._updateButton) {
            this.updateCell();
        }
    }

    @Override
    public void frameArrived(MessageObjectFrame frame) {
        Serializable obj = frame.getObject();
        if (obj instanceof CellInfo) {
            CellInfo info = (CellInfo)obj;
            this._topLabel.setText(">>> " + info.getCellName() + "<<<");
            this._classLabel.setText(info.getCellClass());
            this._shortInfoLabel.setText(info.getShortInfo());
            this._privateInfo.setText(info.getPrivatInfo());
        } else {
            this._privateInfo.setText(obj.toString());
        }
    }

    public void showCell(CellInfo info, String address) {
        this._cellInfo = info;
        this._cellAddress = address;
        this._topLabel.setText(">>> " + info.getCellName() + "<<<");
        this._classLabel.setText(info.getCellClass());
        this._shortInfoLabel.setText(info.getShortInfo());
        this._privateInfo.setText(info.getPrivatInfo());
    }

    private void updateCell() {
        if (this._cellAddress == null) {
            return;
        }
        this._connection.send(this._cellAddress, (Serializable)((Object)("getcellinfo " + this._cellInfo.getCellName())), this);
    }
}

