/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.applets.login;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class RowColumnLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -2955752259527033593L;
    private int _vGap = 10;
    private int _hGap = 10;
    private int _fitsAllSizes = -1;
    private int _columns;
    public static final int NONE = -1;
    public static final int LAST = -2;

    public RowColumnLayout(int columns) {
        this._columns = columns;
    }

    public RowColumnLayout(int columns, int fits) {
        this._columns = columns;
        this._fitsAllSizes = fits == -2 ? this._columns - 1 : fits;
    }

    public void setFitsAllSizes(int fits) {
        this._fitsAllSizes = fits == -2 ? this._columns - 1 : fits;
    }

    public void setHgap(int hGap) {
        this._hGap = hGap;
    }

    public void setVgap(int vGap) {
        this._vGap = vGap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.minimumLayoutSize(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int[][] dim = this.getMinimumDimensions(target);
            Insets insets = target.getInsets();
            int maxwidth = 0;
            int maxheight = 0;
            if (this._fitsAllSizes >= 0 && this._fitsAllSizes < this._columns) {
                Dimension d = target.getSize();
                maxwidth = d.width;
            } else {
                for (int column = 0; column < this._columns; ++column) {
                    maxwidth += dim[1][column];
                }
                maxwidth += insets.left + insets.right + (this._columns - 1) * this._hGap;
            }
            for (int row = 0; row < dim[0].length; ++row) {
                maxheight += dim[0][row];
            }
            return new Dimension(maxwidth, maxheight += insets.top + insets.bottom + (dim[0].length - 1) * this._vGap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[][] getMinimumDimensions(Container target) {
        int[][] dim = new int[2][];
        Object object = target.getTreeLock();
        synchronized (object) {
            int components = target.getComponentCount() / this._columns * this._columns;
            if (components == 0) {
                return dim;
            }
            dim[0] = new int[components / this._columns];
            dim[1] = new int[this._columns];
            for (int i = 0; i < components; ++i) {
                Component m = target.getComponent(i);
                Dimension d = m.getMinimumSize();
                int column = i % this._columns;
                int row = i / this._columns;
                dim[0][row] = Math.max(dim[0][row], d.height);
                dim[1][column] = Math.max(dim[1][column], d.width);
            }
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            Dimension t_dim = target.getSize();
            int maxwidth = t_dim.width - (insets.left + insets.right);
            int maxheight = t_dim.height - (insets.top + insets.bottom);
            int components = target.getComponentCount();
            if (components < 1) {
                return;
            }
            int[][] dim = this.getMinimumDimensions(target);
            components = components / this._columns * this._columns;
            if (this._fitsAllSizes >= 0 && this._fitsAllSizes < this._columns) {
                int sum = 0;
                for (int column = 0; column < this._columns; ++column) {
                    sum += dim[1][column];
                }
                dim[1][this._fitsAllSizes] = t_dim.width - insets.left - insets.right - (sum -= dim[1][this._fitsAllSizes]) - (this._columns - 1) * this._hGap;
            }
            int rows = components / this._columns;
            int y = insets.top;
            int element = 0;
            for (int row = 0; row < rows; ++row) {
                int x = insets.left;
                for (int column = 0; column < this._columns; ++column) {
                    Component m;
                    if ((m = target.getComponent(element++)).isVisible()) {
                        m.validate();
                        m.setSize(dim[1][column], dim[0][row]);
                        m.setLocation(x, y);
                    }
                    x += dim[1][column] + this._hGap;
                }
                y += dim[0][row] + this._vGap;
            }
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

