/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.canl.axis2;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.ProxySupport;
import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.KeyAndCertCredential;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.PEMCredential;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import eu.emi.security.authn.x509.impl.ValidatorParams;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class CANLAXIS2SocketFactory
implements ProtocolSocketFactory {
    private static final String SSL_TIMEOUT_SETTING = null;
    private static final String TIMEOUT_DEFAULT = null;
    private static ThreadLocal theAXIS2SocketFactoryProperties = new ThreadLocal();

    public static Properties getCurrentProperties() {
        Properties thisProperties = (Properties)theAXIS2SocketFactoryProperties.get();
        if (thisProperties == null) {
            thisProperties = System.getProperties();
        }
        return thisProperties;
    }

    public static void clearCurrentProperties() {
        theAXIS2SocketFactoryProperties.set(null);
    }

    public static void setCurrentProperties(Properties cp) {
        theAXIS2SocketFactoryProperties.set(cp);
    }

    private Socket createSocket() throws IOException {
        Properties attributes = CANLAXIS2SocketFactory.getCurrentProperties();
        StoreUpdateListener listener = new StoreUpdateListener(){

            public void loadingNotification(String location, String type, StoreUpdateListener.Severity level, Exception cause) {
                if (level != StoreUpdateListener.Severity.NOTIFICATION) {
                    System.out.println("Error when creating or using SSL socket. Type " + type + " level: " + level + " cause: " + cause.getClass() + ":" + cause.getMessage());
                }
            }
        };
        ArrayList<1> listenerList = new ArrayList<1>();
        listenerList.add(listener);
        RevocationParameters revParam = new RevocationParameters(CrlCheckingMode.REQUIRE);
        String crlCheckingMode = (String)attributes.get("crlcheckingmode");
        if (crlCheckingMode != null) {
            if (crlCheckingMode.equalsIgnoreCase("ifvalid")) {
                revParam = new RevocationParameters(CrlCheckingMode.IF_VALID);
            }
            if (crlCheckingMode.equalsIgnoreCase("ignore")) {
                revParam = new RevocationParameters(CrlCheckingMode.IGNORE);
            }
        }
        ProxySupport proxySupport = ProxySupport.ALLOW;
        String proxySupportString = (String)attributes.get("proxysupport");
        if (proxySupportString != null && (proxySupportString.equalsIgnoreCase("no") || proxySupportString.equalsIgnoreCase("false"))) {
            proxySupport = ProxySupport.DENY;
        }
        ValidatorParams validatorParams = new ValidatorParams(revParam, proxySupport, listenerList);
        String trustStoreLocation = (String)attributes.get("truststore");
        if (trustStoreLocation == null) {
            throw new IOException("No truststore defined, unable to load CA certificates and thus create SSL socket.");
        }
        String namespaceModeString = (String)attributes.get("namespace");
        NamespaceCheckingMode namespaceMode = NamespaceCheckingMode.EUGRIDPMA_AND_GLOBUS;
        if (namespaceModeString != null) {
            if (namespaceModeString.equalsIgnoreCase("no") || namespaceModeString.equalsIgnoreCase("false") || namespaceModeString.equalsIgnoreCase("off")) {
                namespaceMode = NamespaceCheckingMode.IGNORE;
            } else if (namespaceModeString.equalsIgnoreCase("require")) {
                namespaceMode = NamespaceCheckingMode.EUGRIDPMA_AND_GLOBUS_REQUIRE;
            }
        }
        String intervalString = (String)attributes.get("updateinterval");
        long intervalMS = 3600000L;
        if (intervalString != null) {
            intervalMS = Long.parseLong(intervalString);
        }
        OpensslCertChainValidator validator = new OpensslCertChainValidator(trustStoreLocation, namespaceMode, intervalMS, validatorParams);
        PEMCredential credentials = null;
        String proxyLoc = (String)attributes.get("proxy");
        if (proxyLoc != null) {
            try {
                credentials = new PEMCredential(proxyLoc, null);
            }
            catch (KeyStoreException e) {
                throw new IOException("Error opening proxy from " + proxyLoc + ": ", e);
            }
            catch (CertificateException e) {
                throw new IOException("Error reading proxy from " + proxyLoc + ": ", e);
            }
        }
        String hostCertLoc = (String)attributes.get("cert");
        if (hostCertLoc == null) {
            throw new IOException("Variable hostcert undefined, cannot start server with SSL/TLS without host certificate.");
        }
        X509Certificate[] hostCertChain = CertificateUtils.loadCertificateChain((InputStream)new FileInputStream(hostCertLoc), (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
        String password = (String)attributes.get("password");
        String hostKeyLoc = (String)attributes.get("key");
        if (hostKeyLoc == null) {
            throw new IOException("Variable hostkey undefined, cannot start server with SSL/TLS without host private key.");
        }
        PrivateKey hostKey = CertificateUtils.loadPrivateKey((InputStream)new FileInputStream(hostKeyLoc), (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM, (char[])(password == null ? null : password.toCharArray()));
        try {
            credentials = new KeyAndCertCredential(hostKey, hostCertChain);
        }
        catch (KeyStoreException e) {
            throw new IOException("Error while creating keystore: " + e + ": " + e.getMessage(), e);
        }
        SSLSocketFactory factory = SocketFactoryCreator.getSocketFactory((X509Credential)credentials, (X509CertChainValidator)validator);
        SSLSocket socket = (SSLSocket)factory.createSocket();
        return socket;
    }

    private Socket createSocket(Socket s, boolean autoclose) throws IOException {
        throw new IOException("createSocket(s, ac) unimplemented");
    }

    private final Socket connectSocket(Socket socket, SocketAddress remoteaddr, SocketAddress localaddr, int timeout) throws IOException {
        int newTimeout = timeout;
        if (localaddr != null) {
            socket.bind(localaddr);
        }
        if (timeout == 0) {
            String timeoutString = CANLAXIS2SocketFactory.getCurrentProperties().getProperty(SSL_TIMEOUT_SETTING, TIMEOUT_DEFAULT);
            newTimeout = Integer.parseInt(timeoutString);
        }
        socket.setSoTimeout(newTimeout);
        socket.connect(remoteaddr, newTimeout);
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        int timeout = params.getConnectionTimeout();
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        InetSocketAddress localaddr = new InetSocketAddress(localHost, localPort);
        this.connectSocket(socket, remoteaddr, localaddr, timeout);
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        InetSocketAddress localaddr = new InetSocketAddress(localHost, localPort);
        this.connectSocket(socket, remoteaddr, localaddr, 0);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        this.connectSocket(socket, remoteaddr, null, 0);
        return socket;
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        Socket socket = this.createSocket(s, autoClose);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        this.connectSocket(socket, remoteaddr, null, 0);
        return socket;
    }
}

