/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.pem.PemHeader;
import org.bouncycastle.util.io.pem.PemObject;

public class FlexiblePEMReader
extends PEMReader {
    public FlexiblePEMReader(Reader reader) {
        super(reader);
    }

    public FlexiblePEMReader(Reader reader, PasswordFinder pFinder, String symProvider, String asymProvider) {
        super(reader, pFinder, symProvider, asymProvider);
    }

    public FlexiblePEMReader(Reader reader, PasswordFinder pFinder, String provider) {
        super(reader, pFinder, provider);
    }

    public FlexiblePEMReader(Reader reader, PasswordFinder pFinder) {
        super(reader, pFinder);
    }

    public PemObject readPemObject() throws IOException {
        Matcher m;
        String line;
        Pattern starter = Pattern.compile("^---[-]+BEGIN [^-]+---[-]+$");
        Pattern end = Pattern.compile("^---[-]+END [^-]+---[-]+$");
        boolean startFound = false;
        while ((line = this.readLine()) != null) {
            Matcher m2 = starter.matcher(line);
            if (!m2.find()) continue;
            startFound = true;
            break;
        }
        if (!startFound) {
            return null;
        }
        int pos = line.indexOf("BEGIN ") + 6;
        int endPos = line.indexOf(45, pos);
        String type = line.substring(pos, endPos);
        boolean endFound = false;
        StringBuilder sb = new StringBuilder();
        ArrayList<PemHeader> headers = new ArrayList<PemHeader>();
        while ((line = this.readLine()) != null) {
            m = end.matcher(line);
            if (m.find()) {
                throw new IOException("The supplied data is not in PEM format, end line found before getting any contents.");
            }
            if (line.indexOf(":") >= 0) {
                int index = line.indexOf(58);
                String hdr = line.substring(0, index);
                String value = line.substring(index + 1).trim();
                headers.add(new PemHeader(hdr, value));
                continue;
            }
            sb.append(line.trim());
            break;
        }
        while ((line = this.readLine()) != null) {
            m = end.matcher(line);
            if (m.find()) {
                endFound = true;
                break;
            }
            sb.append(line.trim());
        }
        if (!endFound) {
            throw new IOException("The supplied data is not in PEM format, no ending line found.");
        }
        return new PemObject(type, headers, Base64.decode((String)sb.toString()));
    }
}

