/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.server.config;

import java.io.Reader;
import java.util.List;
import java.util.StringTokenizer;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.config.AbstractIniServiceConfigurationParser;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.IniConfigUtil;
import org.glite.authz.pep.obligation.IniOHConfigurationParserHelper;
import org.glite.authz.pep.obligation.ObligationService;
import org.glite.authz.pep.pip.IniPIPConfigurationParserHelper;
import org.glite.authz.pep.pip.PolicyInformationPoint;
import org.glite.authz.pep.server.config.PEPDaemonConfiguration;
import org.glite.authz.pep.server.config.PEPDaemonConfigurationBuilder;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.opensaml.ws.soap.client.SOAPClient;
import org.opensaml.ws.soap.client.http.HttpClientBuilder;
import org.opensaml.ws.soap.client.http.HttpSOAPClient;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class PEPDaemonIniConfigurationParser
extends AbstractIniServiceConfigurationParser<PEPDaemonConfiguration> {
    public static final String PDP_SECTION_HEADER = "PDP";
    public static final String PDP_PROP = "pdps";
    public static final String MAX_CACHED_RESP_PROP = "maximumCachedResponses";
    public static final String CACHED_RESP_TTL_PROP = "cachedResponseTTL";
    public static final int DEFAULT_PORT = 8154;
    public static final int DEFAULT_ADMIN_PORT = 8155;
    public static final int DEFAULT_MAX_CACHED_RESP = 500;
    public static final int DEFAULT_CACHED_RESP_TTL = 600;
    private final Logger log = LoggerFactory.getLogger(PEPDaemonIniConfigurationParser.class);

    protected int getPort(Profile.Section configSection) {
        return IniConfigUtil.getInt((Profile.Section)configSection, (String)"port", (int)8154, (int)1, (int)65535);
    }

    protected int getAdminPort(Profile.Section configSection) {
        return IniConfigUtil.getInt((Profile.Section)configSection, (String)"adminPort", (int)8155, (int)1, (int)65535);
    }

    protected int getCacheResponseTTL(Profile.Section configSection) {
        return IniConfigUtil.getInt((Profile.Section)configSection, (String)CACHED_RESP_TTL_PROP, (int)600, (int)1, (int)Integer.MAX_VALUE);
    }

    protected int getMaxCachedResponses(Profile.Section configSection) {
        return IniConfigUtil.getInt((Profile.Section)configSection, (String)MAX_CACHED_RESP_PROP, (int)500, (int)0, (int)Integer.MAX_VALUE);
    }

    protected PEPDaemonConfiguration parseIni(Reader iniReader) throws ConfigurationException {
        Ini iniFile = new Ini();
        try {
            this.log.info("Loading and parsing INI configuration file");
            iniFile.load(iniReader);
        }
        catch (Exception e) {
            this.log.error("Unable to load and parse the INI configuration file", (Throwable)e);
            throw new ConfigurationException("Unable to parse INI configuration file", e);
        }
        PEPDaemonConfigurationBuilder configBuilder = new PEPDaemonConfigurationBuilder();
        this.log.info("Processing PEP Server {} configuration section", (Object)"SECURITY");
        this.processSecuritySection(iniFile, configBuilder);
        this.log.info("Processing PEP Server {} configuration section", (Object)"SERVICE");
        this.processServiceSection(iniFile, configBuilder);
        Profile.Section configSection = (Profile.Section)iniFile.get((Object)"SERVICE");
        List<PolicyInformationPoint> pips = IniPIPConfigurationParserHelper.processPolicyInformationPoints(iniFile, configSection, configBuilder);
        this.log.info("Total policy information points: {}", (Object)pips.size());
        configBuilder.getPolicyInformationPoints().addAll(pips);
        ObligationService service = IniOHConfigurationParserHelper.processObligationHandlers(iniFile, configSection, configBuilder);
        this.log.info("Total obligation handlers: {}", (Object)service.getObligationHandlers().size());
        configBuilder.setObligationService(service);
        this.log.info("Processing PEP Server {} configuration section", (Object)PDP_SECTION_HEADER);
        this.processPDPConfiguration(iniFile, configBuilder);
        return configBuilder.build();
    }

    private void processPDPConfiguration(Ini iniFile, PEPDaemonConfigurationBuilder configBuilder) throws ConfigurationException {
        Profile.Section configSection = (Profile.Section)iniFile.get((Object)PDP_SECTION_HEADER);
        if (configSection == null) {
            String errorMsg = "INI configuration does not contain the required 'PDP' INI section";
            this.log.error(errorMsg);
            throw new ConfigurationException(errorMsg);
        }
        String name = configSection.getName();
        String pdpEndpointStr = IniConfigUtil.getString((Profile.Section)configSection, (String)PDP_PROP);
        this.log.info("{}: PDP endpoints: {}", (Object)name, (Object)pdpEndpointStr);
        StringTokenizer pdpEndpoints = new StringTokenizer(pdpEndpointStr, " ");
        while (pdpEndpoints.hasMoreTokens()) {
            configBuilder.getPDPEndpoints().add(pdpEndpoints.nextToken());
        }
        int maxCachedResponses = this.getMaxCachedResponses(configSection);
        this.log.info("{}: max cached responses: {}", (Object)name, (Object)maxCachedResponses);
        configBuilder.setMaxCachedResponses(maxCachedResponses);
        int cachedResponseTTL = this.getCacheResponseTTL(configSection) * 1000;
        this.log.info("{}: cached response TTL: {}ms", (Object)name, (Object)cachedResponseTTL);
        configBuilder.setCachedResponseTTL(cachedResponseTTL);
        HttpClientBuilder soapClientBuilder = this.buildSOAPClientBuilder(configSection, configBuilder.getKeyManager(), configBuilder.getTrustManager());
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.setMaxPoolSize(soapClientBuilder.getMaxTotalConnections());
        configBuilder.setSoapClient((SOAPClient)new HttpSOAPClient(soapClientBuilder.buildClient(), (ParserPool)parserPool));
    }
}

