/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.server.config;

import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.glite.authz.common.config.AbstractServiceConfiguration;
import org.glite.authz.common.config.AbstractServiceConfigurationBuilder;
import org.glite.authz.pep.obligation.ObligationService;
import org.glite.authz.pep.pip.PolicyInformationPoint;
import org.glite.authz.pep.server.config.PEPDaemonConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class PEPDaemonConfigurationBuilder
extends AbstractServiceConfigurationBuilder<PEPDaemonConfiguration> {
    private List<String> pdpEndpoints;
    private int maxCachedResponses;
    private long cachedResponseTTL;
    private List<PolicyInformationPoint> pips;
    private ObligationService obligationService;

    public PEPDaemonConfigurationBuilder() {
        this.pdpEndpoints = new ArrayList<String>();
        this.pips = new ArrayList<PolicyInformationPoint>();
    }

    public PEPDaemonConfigurationBuilder(PEPDaemonConfiguration prototype) {
        super((AbstractServiceConfiguration)prototype);
        this.pdpEndpoints = prototype.getPDPEndpoints() != null ? new ArrayList<String>(prototype.getPDPEndpoints()) : new ArrayList<String>();
        this.cachedResponseTTL = prototype.getCachedResponseTTL();
        this.maxCachedResponses = prototype.getMaxCachedResponses();
    }

    public long getCachedResponseTTL() {
        return this.cachedResponseTTL;
    }

    public int getMaxCachedResponses() {
        return this.maxCachedResponses;
    }

    public void setCachedResponseTTL(long ttl) {
        this.cachedResponseTTL = ttl;
    }

    public void setMaxCachedResponses(int max) {
        this.maxCachedResponses = max;
    }

    public List<String> getPDPEndpoints() {
        return this.pdpEndpoints;
    }

    public List<PolicyInformationPoint> getPolicyInformationPoints() {
        return this.pips;
    }

    public ObligationService getObligationService() {
        return this.obligationService;
    }

    public void setObligationService(ObligationService service) {
        this.obligationService = service;
    }

    public PEPDaemonConfiguration build() {
        PEPDaemonConfiguration config = new PEPDaemonConfiguration();
        this.populateConfiguration(config);
        config.setPDPEndpoints(this.pdpEndpoints);
        config.setCachedResponseTTL(this.cachedResponseTTL);
        config.setMaxCachedResponses(this.maxCachedResponses);
        config.setPolicyInformationPoints(this.pips);
        config.setObligationService(this.obligationService);
        return config;
    }
}

