/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.server.config;

import java.util.Collections;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.ServiceMetrics;
import org.glite.authz.common.config.AbstractServiceConfiguration;
import org.glite.authz.pep.obligation.ObligationService;
import org.glite.authz.pep.pip.PolicyInformationPoint;
import org.glite.authz.pep.server.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class PEPDaemonConfiguration
extends AbstractServiceConfiguration {
    private List<String> pdpEndpoints = null;
    private int maxCachedResponses = 0;
    private long cachedResponseTTL = 0L;
    private List<PolicyInformationPoint> pips;
    private ObligationService obligationService;

    public PEPDaemonConfiguration() {
        super(new ServiceMetrics(Version.getServiceName(), Version.getServiceVersion()));
    }

    public long getCachedResponseTTL() {
        return this.cachedResponseTTL;
    }

    public int getMaxCachedResponses() {
        return this.maxCachedResponses;
    }

    public List<String> getPDPEndpoints() {
        return this.pdpEndpoints;
    }

    public List<PolicyInformationPoint> getPolicyInformationPoints() {
        return this.pips;
    }

    public ObligationService getObligationService() {
        return this.obligationService;
    }

    protected final synchronized void setCachedResponseTTL(long ttl) {
        if (ttl < 1L) {
            throw new IllegalArgumentException("Cache response time to live must be greater than zero");
        }
        if (this.cachedResponseTTL != 0L) {
            throw new IllegalStateException("Cached response TTL has already been set, it may not be changed.");
        }
        this.cachedResponseTTL = ttl;
    }

    protected final synchronized void setMaxCachedResponses(int max) {
        if (max < 0) {
            throw new IllegalArgumentException("Max resonse cache size must be greater than zero");
        }
        if (this.maxCachedResponses != 0) {
            throw new IllegalStateException("Max response cache size has already been set, it may not be changed.");
        }
        this.maxCachedResponses = max;
    }

    protected final synchronized void setPDPEndpoints(List<String> endpoints) {
        if (endpoints == null || endpoints.size() == 0) {
            return;
        }
        if (this.pdpEndpoints != null) {
            throw new IllegalStateException("PDP endpoints have already been set, they may not be changed.");
        }
        this.pdpEndpoints = Collections.unmodifiableList(endpoints);
    }

    protected final synchronized void setPolicyInformationPoints(List<PolicyInformationPoint> policyInformationPoints) {
        if (policyInformationPoints == null) {
            return;
        }
        if (this.pips != null) {
            throw new IllegalArgumentException("Policy Information Points have already been set, they may not be changed");
        }
        this.pips = Collections.unmodifiableList(policyInformationPoints);
    }

    protected final synchronized void setObligationService(ObligationService service) {
        if (service == null) {
            return;
        }
        if (this.obligationService != null) {
            throw new IllegalArgumentException("Obligation service has already been set, they may not be changed");
        }
        this.obligationService = service;
    }
}

