/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.server;

import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.http.BaseHttpServlet;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Response;
import org.glite.authz.common.util.Base64;
import org.glite.authz.pep.server.PEPDaemonRequestHandler;
import org.glite.authz.pep.server.config.PEPDaemonConfiguration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.xml.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PEPDaemonServlet
extends BaseHttpServlet {
    private static final long serialVersionUID = -4114670420901954784L;
    private final Logger protocolLog = LoggerFactory.getLogger((String)"org.glite.authz.message.protocol");
    private PEPDaemonRequestHandler requestHandler;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        PEPDaemonConfiguration daemonConfig = (PEPDaemonConfiguration)((Object)this.getServletContext().getAttribute("org.glite.authz.common.config"));
        if (daemonConfig == null) {
            throw new ServletException("Unable to initialize, no daemon configuration available in servlet context");
        }
        this.requestHandler = new PEPDaemonRequestHandler(daemonConfig);
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            throw new ServletException("Error initializing OpenSAML library", (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        HessianInput hin = new HessianInput((InputStream)new Base64.InputStream((InputStream)httpRequest.getInputStream()));
        Request request = (Request)hin.readObject(Request.class);
        this.protocolLog.debug("Incomming hessian request\n{}", (Object)request.toString());
        Response response = this.requestHandler.handle(request);
        this.protocolLog.debug("Outgoing hessian response\n{}", (Object)response.toString());
        ByteArrayOutputStream responseBytes = new ByteArrayOutputStream();
        HessianOutput hout = new HessianOutput((OutputStream)responseBytes);
        hout.writeObject((Object)response);
        hout.flush();
        httpResponse.getWriter().write(Base64.encodeBytes((byte[])responseBytes.toByteArray()));
        httpResponse.flushBuffer();
    }

    protected String getSupportedMethods() {
        return "POST";
    }
}

