/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.server;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.glite.authz.common.context.DecisionRequestContext;
import org.glite.authz.common.context.DecisionRequestContextHelper;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Response;
import org.glite.authz.common.model.Result;
import org.glite.authz.common.model.Status;
import org.glite.authz.common.model.StatusCode;
import org.glite.authz.common.model.util.XACMLConverter;
import org.glite.authz.pep.obligation.ObligationProcessingException;
import org.glite.authz.pep.pip.PIPProcessingException;
import org.glite.authz.pep.pip.PolicyInformationPoint;
import org.glite.authz.pep.server.AuditLogEntry;
import org.glite.authz.pep.server.config.PEPDaemonConfiguration;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.ws.soap.client.SOAPClient;
import org.opensaml.ws.soap.client.SOAPFaultException;
import org.opensaml.ws.soap.client.SOAPMessageContext;
import org.opensaml.ws.soap.client.http.HttpSOAPRequestParameters;
import org.opensaml.ws.soap.common.SOAPException;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionStatementType;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@ThreadSafe
public class PEPDaemonRequestHandler {
    public static final String RESPONSE_CACHE_NAME = "org.glite.authz.pep.server.responseCache";
    private final Logger log = LoggerFactory.getLogger(PEPDaemonRequestHandler.class);
    private final Logger auditLog = LoggerFactory.getLogger((String)"org.glite.authz.audit");
    private final Logger protocolLog = LoggerFactory.getLogger((String)"org.glite.authz.message.protocol");
    private PEPDaemonConfiguration daemonConfig;
    private Cache responseCache;

    public PEPDaemonRequestHandler(PEPDaemonConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("Daemon configuration may not be null");
        }
        this.daemonConfig = config;
        if (this.daemonConfig.getMaxCachedResponses() > 0) {
            CacheManager cacheMgr = CacheManager.create();
            this.responseCache = new Cache(RESPONSE_CACHE_NAME, this.daemonConfig.getMaxCachedResponses(), MemoryStoreEvictionPolicy.LFU, false, null, false, this.daemonConfig.getCachedResponseTTL(), this.daemonConfig.getCachedResponseTTL(), false, Long.MAX_VALUE, null, null);
            cacheMgr.addCache(this.responseCache);
        } else {
            this.responseCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request) throws IOException {
        this.daemonConfig.getServiceMetrics().incrementTotalServiceRequests();
        PEPDaemonDecisionRequestContext messageContext = this.buildMessageContext(this.daemonConfig.getEntityId());
        Response response = null;
        try {
            for (PolicyInformationPoint pip : this.daemonConfig.getPolicyInformationPoints()) {
                if (pip.populateRequest(request)) {
                    this.log.debug("PIP {} applied to Hessian request", (Object)pip.getId());
                    continue;
                }
                this.log.debug("PIP {} do not apply to request", (Object)pip.getId());
            }
            this.protocolLog.info("Hessian request after PIPs have been run\n{}", (Object)request.toString());
            if (this.responseCache != null) {
                Response cachedResponse;
                this.log.debug("Checking if a response has already been cached for this request");
                Element cacheElement = this.responseCache.get((Serializable)request);
                if (cacheElement != null && (cachedResponse = (Response)cacheElement.getValue()) != null) {
                    this.log.debug("Cached response found, using it");
                    response = cachedResponse;
                }
            }
            if (response == null) {
                this.log.debug("Response not found in cache, send to PDP");
                response = this.sendRequestToPDP(messageContext, request);
                if (response == null) {
                    String error = "No response received from PDP: " + this.daemonConfig.getPDPEndpoints();
                    this.log.error(error);
                    this.daemonConfig.getServiceMetrics().incrementTotalServiceRequestErrors();
                    response = this.buildErrorResponse(request, "urn:oasis:names:tc:xacml:1.0:status:processing-error", error);
                    this.writeAuditLogEntry(messageContext);
                    Response response2 = response;
                    return response2;
                }
            }
            Result result = (Result)response.getResults().get(0);
            if (this.responseCache != null && (result.getDecision() == 0 || result.getDecision() == 1)) {
                this.log.debug("Caching response {} for request {}", (Object)messageContext.getInboundMessageId(), (Object)messageContext.getOutboundMessageId());
                this.responseCache.put(new Element((Serializable)request, (Serializable)response));
            }
            if (this.daemonConfig.getObligationService() != null) {
                this.log.debug("Processing obligations");
                this.daemonConfig.getObligationService().processObligations(request, result);
            }
        }
        catch (PIPProcessingException e) {
            this.daemonConfig.getServiceMetrics().incrementTotalServiceRequestErrors();
            this.log.error("Error processing PIP: " + e.getMessage());
            this.log.debug("", (Throwable)e);
            response = this.buildErrorResponse(request, "urn:oasis:names:tc:xacml:1.0:status:processing-error", e.getMessage());
        }
        catch (ObligationProcessingException e) {
            this.daemonConfig.getServiceMetrics().incrementTotalServiceRequestErrors();
            this.log.error("Error processing obligation handlers: " + e.getMessage());
            this.log.debug("", (Throwable)e);
            response = this.buildErrorResponse(request, "urn:oasis:names:tc:xacml:1.0:status:processing-error", e.getMessage());
        }
        catch (Exception e) {
            this.daemonConfig.getServiceMetrics().incrementTotalServiceRequestErrors();
            this.log.error("Error processing authorization request: " + e.getMessage());
            this.log.debug("", (Throwable)e);
            response = this.buildErrorResponse(request, "urn:oasis:names:tc:xacml:1.0:status:processing-error", e.getMessage());
        }
        finally {
            this.protocolLog.info("Complete hessian response\n{}", (Object)response.toString());
        }
        this.writeAuditLogEntry(messageContext);
        return response;
    }

    private Response sendRequestToPDP(PEPDaemonDecisionRequestContext messageContext, Request authzRequest) {
        RequestType xacmlRequest = XACMLConverter.requestToXACML(authzRequest);
        Envelope soapRequest = DecisionRequestContextHelper.buildSOAPMessage((String)this.daemonConfig.getEntityId(), (DecisionRequestContext)messageContext, (RequestType)xacmlRequest);
        this.logSOAPProtocolMessage((XMLObject)soapRequest, true);
        Iterator<String> pdpItr = this.daemonConfig.getPDPEndpoints().iterator();
        String pdpEndpoint = null;
        Response authzResponse = null;
        String errorMessage = null;
        while (pdpItr.hasNext()) {
            String error;
            try {
                pdpEndpoint = pdpItr.next();
                this.log.debug("Sending request {} to {}", (Object)messageContext.getOutboundMessageId(), (Object)pdpEndpoint);
                this.daemonConfig.getSOAPClient().send(pdpEndpoint, (SOAPMessageContext)messageContext);
                authzResponse = this.extractResponse(messageContext, pdpEndpoint, (Envelope)messageContext.getInboundMessage());
                if (authzResponse == null) continue;
                this.logSOAPProtocolMessage(messageContext.getInboundMessage(), false);
                messageContext.setRespondingPDP(pdpEndpoint);
                messageContext.setAuthorizationDecision(((Result)authzResponse.getResults().get(0)).getDecisionString());
                break;
            }
            catch (SOAPFaultException e) {
                error = "Recieved SOAP Fault " + e.getFault().getCode() + " from PDP: " + pdpEndpoint;
                this.log.warn(error, (Throwable)e);
                errorMessage = error;
            }
            catch (SOAPException e) {
                error = "Error sending request to PDP: " + pdpEndpoint;
                this.log.error(error, (Throwable)e);
                errorMessage = error;
            }
            catch (SecurityException e) {
                error = "Response from PDP " + pdpEndpoint + " did not meet message security requirements";
                this.log.error(error, (Throwable)e);
                errorMessage = error;
            }
        }
        if (authzResponse != null) {
            this.log.debug("A decision of {} was reached by {} in response to request {}", new Object[]{((Result)authzResponse.getResults().get(0)).getDecisionString(), messageContext.getRespondingPDP(), messageContext.getOutboundMessageId()});
            return authzResponse;
        }
        this.log.error("No PDP endpoint was able to answer the authorization request");
        messageContext.setProcessingError(errorMessage);
        return null;
    }

    private Response extractResponse(DecisionRequestContext messageContext, String pdpEndpoint, Envelope soapResponse) {
        org.opensaml.saml2.core.Response samlResponse = (org.opensaml.saml2.core.Response)soapResponse.getBody().getOrderedChildren().get(0);
        if (samlResponse.getAssertions() == null || samlResponse.getAssertions().isEmpty()) {
            this.log.warn("Response from PDP {} was an invalid message.  It did not contain an assertion", (Object)pdpEndpoint);
            return null;
        }
        if (samlResponse.getAssertions().size() > 1) {
            this.log.warn("Response from PDP {} was an invalid message.  It contained more than 1 assertion", (Object)pdpEndpoint);
            return null;
        }
        Assertion samlAssertion = (Assertion)samlResponse.getAssertions().get(0);
        List authzStatements = samlAssertion.getStatements(XACMLAuthzDecisionStatementType.TYPE_NAME_XACML20);
        if (authzStatements == null || authzStatements.isEmpty()) {
            this.log.warn("Response from PDP {} was an invalid message.  It did not contain an authorization statement", (Object)pdpEndpoint);
            return null;
        }
        if (authzStatements.size() > 1) {
            this.log.warn("Response from PDP {} was an invalid message.  It contained more than 1 authorization statement", (Object)pdpEndpoint);
            return null;
        }
        messageContext.setInboundMessageId(samlResponse.getID());
        XACMLAuthzDecisionStatementType authzStatement = (XACMLAuthzDecisionStatementType)authzStatements.get(0);
        return XACMLConverter.responseFromXACML(authzStatement.getResponse(), authzStatement.getRequest());
    }

    private Response buildErrorResponse(Request request, String statusCode, String errorMessage) {
        StatusCode errorCode = new StatusCode();
        errorCode.setCode(statusCode);
        Status status = new Status();
        status.setCode(errorCode);
        if (errorMessage != null) {
            status.setMessage(errorMessage);
        }
        Result result = new Result();
        result.setDecision(2);
        result.setStatus(status);
        Response response = new Response();
        response.setRequest(request);
        response.getResults().add(result);
        return response;
    }

    private void logSOAPProtocolMessage(XMLObject message, boolean isRequest) {
        if (message == null) {
            return;
        }
        if (this.protocolLog.isDebugEnabled()) {
            try {
                org.w3c.dom.Element messageDom = Configuration.getMarshallerFactory().getMarshaller(message).marshall(message);
                if (isRequest) {
                    this.protocolLog.debug("Outgoing SOAP request\n{}", (Object)XMLHelper.prettyPrintXML((Node)messageDom));
                } else {
                    this.protocolLog.debug("Inbound SOAP response\n{}", (Object)XMLHelper.prettyPrintXML((Node)messageDom));
                }
            }
            catch (MarshallingException e) {
                this.log.error("Unable to marshall SOAP message");
            }
        }
    }

    private void writeAuditLogEntry(PEPDaemonDecisionRequestContext messageContext) {
        AuditLogEntry entry = new AuditLogEntry(messageContext.getOutboundMessageId(), messageContext.getRespondingPDP(), messageContext.getInboundMessageId(), messageContext.getAuthorizationDecision());
        entry.setErrorMessage(messageContext.getProcessingError());
        this.auditLog.info(entry.toString());
    }

    protected PEPDaemonDecisionRequestContext buildMessageContext(String messageIssuerId) {
        PEPDaemonDecisionRequestContext messageContext = new PEPDaemonDecisionRequestContext();
        messageContext.setCommunicationProfileId("urn:mace:switch.ch:doc:xacml-saml:profile:200711:SOAP");
        messageContext.setOutboundMessageIssuer(messageIssuerId);
        messageContext.setSOAPRequestParameters((SOAPClient.SOAPRequestParameters)new HttpSOAPRequestParameters("http://www.oasis-open.org/committees/security"));
        return messageContext;
    }

    protected class PEPDaemonDecisionRequestContext
    extends DecisionRequestContext {
        private String processingError_;

        protected PEPDaemonDecisionRequestContext() {
        }

        public String getProcessingError() {
            return this.processingError_;
        }

        public void setProcessingError(String processingError) {
            this.processingError_ = processingError;
        }
    }
}

