/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.server;

import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.AbstractQueue;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Status;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.http.AbstractAdminCommand;
import org.glite.authz.common.http.CertChainValidatorDisposeTask;
import org.glite.authz.common.http.JettyAdminService;
import org.glite.authz.common.http.JettyRunThread;
import org.glite.authz.common.http.JettyServerShutdownTask;
import org.glite.authz.common.http.JettySslSelectChannelConnector;
import org.glite.authz.common.http.ServiceMetricsServlet;
import org.glite.authz.common.http.ShutdownTask;
import org.glite.authz.common.http.StatusCommand;
import org.glite.authz.common.http.SystemExitTask;
import org.glite.authz.common.http.TimerShutdownTask;
import org.glite.authz.common.logging.AccessLoggingFilter;
import org.glite.authz.common.logging.LoggingReloadTask;
import org.glite.authz.common.util.Files;
import org.glite.authz.pep.pip.PolicyInformationPoint;
import org.glite.authz.pep.pip.PolicyInformationPointsShutdownTask;
import org.glite.authz.pep.server.ClearResponseCacheCommand;
import org.glite.authz.pep.server.PEPDaemonServlet;
import org.glite.authz.pep.server.Version;
import org.glite.authz.pep.server.config.PEPDaemonConfiguration;
import org.glite.authz.pep.server.config.PEPDaemonIniConfigurationParser;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.ThreadPool;
import org.opensaml.DefaultBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PEPDaemon {
    public static final String PEP_HOME_PROP = "org.glite.authz.pep.home";
    public static final String PEP_CONFDIR_PROP = "org.glite.authz.pep.confdir";
    public static final String PEP_LOGDIR_PROP = "org.glite.authz.pep.logdir";
    public static final String PEP_GRACEFUL_PROP = "org.glite.authz.pep.server.graceful";
    public static int DEFAULT_ADMIN_PORT = 8155;
    public static String DEFAULT_ADMIN_HOST = "localhost";
    public static int DEFAULT_SERVICE_PORT = 8154;
    public static final int DEFAULT_LOGGING_CONFIG_REFRESH_PERIOD = 300000;
    private static final Logger LOG = LoggerFactory.getLogger(PEPDaemon.class);

    private PEPDaemon() {
    }

    public static void main(String[] args) throws Exception {
        String confDir;
        if (args.length < 1 || args.length > 1) {
            PEPDaemon.errorAndExit("Missing configuration file argument", null);
        }
        if ((confDir = System.getProperty(PEP_CONFDIR_PROP)) == null) {
            PEPDaemon.errorAndExit("System property org.glite.authz.pep.confdir is not set", null);
        }
        Timer backgroundTaskTimer = new Timer(true);
        String loggingConfigFilePath = confDir + "/logging.xml";
        PEPDaemon.initializeLogging(loggingConfigFilePath, backgroundTaskTimer);
        Security.addProvider((Provider)new BouncyCastleProvider());
        DefaultBootstrap.bootstrap();
        PEPDaemonConfiguration daemonConfig = PEPDaemon.parseConfiguration(args[0]);
        List<PolicyInformationPoint> pips = daemonConfig.getPolicyInformationPoints();
        if (pips != null && !pips.isEmpty()) {
            LOG.info("Starting all PIPs");
            for (PolicyInformationPoint pip : daemonConfig.getPolicyInformationPoints()) {
                if (pip == null) continue;
                LOG.debug("Starting PIP {}", (Object)pip.getId());
                pip.start();
            }
        }
        final Server pepServer = PEPDaemon.createPEPDaemonService(daemonConfig);
        JettyRunThread pepDaemonServiceThread = new JettyRunThread(pepServer);
        pepDaemonServiceThread.setName("PEP Server Service");
        pepDaemonServiceThread.start();
        JettyAdminService adminService = PEPDaemon.createAdminService(daemonConfig, backgroundTaskTimer, pepServer);
        LOG.debug("Starting admin service");
        adminService.start();
        LOG.debug("Register shutdown hook");
        Runtime.getRuntime().addShutdownHook(new Thread(){
            ShutdownTask task;
            {
                this.task = new JettyServerShutdownTask(pepServer);
            }

            public void run() {
                this.task.run();
            }
        });
        LOG.info(Version.getServiceIdentifier() + " started");
    }

    private static Server createPEPDaemonService(PEPDaemonConfiguration daemonConfig) {
        Server httpServer = new Server();
        httpServer.setSendServerVersion(false);
        httpServer.setSendDateHeader(false);
        if (System.getProperty(PEP_GRACEFUL_PROP) != null) {
            LOG.info("Graceful shutdown enabled: org.glite.authz.pep.server.graceful");
            httpServer.setGracefulShutdown(10000);
        }
        httpServer.setStopAtShutdown(true);
        AbstractQueue requestQueue = daemonConfig.getMaxRequestQueueSize() < 1 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(daemonConfig.getMaxRequestQueueSize());
        org.mortbay.thread.concurrent.ThreadPool threadPool = new org.mortbay.thread.concurrent.ThreadPool(5, daemonConfig.getMaxRequests(), 1L, TimeUnit.SECONDS, requestQueue);
        httpServer.setThreadPool((ThreadPool)threadPool);
        Connector connector = PEPDaemon.createServiceConnector(daemonConfig);
        httpServer.setConnectors(new Connector[]{connector});
        Context servletContext = new Context((HandlerContainer)httpServer, "/", false, false);
        servletContext.setDisplayName("PEP Server");
        servletContext.setAttribute("org.glite.authz.common.config", (Object)daemonConfig);
        FilterHolder accessLoggingFilter = new FilterHolder((Filter)new AccessLoggingFilter());
        servletContext.addFilter(accessLoggingFilter, "/*", 1);
        ServletHolder authzRequestServlet = new ServletHolder((Servlet)new PEPDaemonServlet());
        authzRequestServlet.setName("Authorization Servlet");
        servletContext.addServlet(authzRequestServlet, "/authz");
        ServletHolder statusRequestServlet = new ServletHolder((Servlet)new ServiceMetricsServlet(daemonConfig.getServiceMetrics()));
        statusRequestServlet.setName("Status Servlet");
        servletContext.addServlet(statusRequestServlet, "/status");
        return httpServer;
    }

    private static JettyAdminService createAdminService(PEPDaemonConfiguration daemonConfig, Timer backgroundTimer, Server daemonService) {
        int adminPort;
        String adminHost = daemonConfig.getAdminHost();
        if (adminHost == null) {
            adminHost = DEFAULT_ADMIN_HOST;
        }
        if ((adminPort = daemonConfig.getAdminPort()) < 1) {
            adminPort = DEFAULT_ADMIN_PORT;
        }
        JettyAdminService adminService = new JettyAdminService(adminHost, adminPort, daemonConfig.getAdminPassword());
        adminService.registerAdminCommand((AbstractAdminCommand)new StatusCommand(daemonConfig.getServiceMetrics()));
        adminService.registerAdminCommand((AbstractAdminCommand)new ClearResponseCacheCommand());
        adminService.registerShutdownTask((ShutdownTask)new SystemExitTask(60000L));
        adminService.registerShutdownTask((ShutdownTask)new TimerShutdownTask(backgroundTimer));
        adminService.registerShutdownTask((ShutdownTask)new JettyServerShutdownTask(daemonService));
        adminService.registerShutdownTask(new ShutdownTask(){

            public void run() {
                CacheManager cacheMgr = CacheManager.getInstance();
                if (cacheMgr != null && cacheMgr.getStatus() == Status.STATUS_ALIVE) {
                    cacheMgr.shutdown();
                }
            }
        });
        adminService.registerShutdownTask((ShutdownTask)new PolicyInformationPointsShutdownTask(daemonConfig.getPolicyInformationPoints()));
        X509CertChainValidatorExt validator = daemonConfig.getCertChainValidator();
        adminService.registerShutdownTask((ShutdownTask)new CertChainValidatorDisposeTask(validator));
        return adminService;
    }

    private static Connector createServiceConnector(PEPDaemonConfiguration daemonConfig) {
        SelectChannelConnector connector;
        if (!daemonConfig.isSslEnabled()) {
            connector = new SelectChannelConnector();
        } else {
            if (daemonConfig.getKeyManager() == null) {
                LOG.error("Service port was meant to be SSL enabled but no service key/certificate was specified in the configuration file");
            }
            if (daemonConfig.getTrustManager() == null) {
                LOG.error("Service port was meant to be SSL enabled but no trust information directory was specified in the configuration file");
            }
            connector = new JettySslSelectChannelConnector(daemonConfig.getKeyManager(), daemonConfig.getTrustManager());
            if (daemonConfig.isClientCertAuthRequired()) {
                ((JettySslSelectChannelConnector)connector).setNeedClientAuth(true);
            }
        }
        connector.setHost(daemonConfig.getHostname());
        if (daemonConfig.getPort() == 0) {
            connector.setPort(DEFAULT_SERVICE_PORT);
        } else {
            connector.setPort(daemonConfig.getPort());
        }
        connector.setMaxIdleTime(daemonConfig.getConnectionTimeout());
        connector.setRequestBufferSize(daemonConfig.getReceiveBufferSize());
        connector.setResponseBufferSize(daemonConfig.getSendBufferSize());
        return connector;
    }

    private static PEPDaemonConfiguration parseConfiguration(String configFilePath) {
        File configFile = null;
        try {
            LOG.info("PEP Daemon configuration file: {}", (Object)configFilePath);
            configFile = Files.getReadableFile((String)configFilePath);
        }
        catch (IOException e) {
            PEPDaemon.errorAndExit(e.getMessage(), null);
        }
        try {
            PEPDaemonIniConfigurationParser configParser = new PEPDaemonIniConfigurationParser();
            return (PEPDaemonConfiguration)configParser.parse(new FileReader(configFile));
        }
        catch (IOException e) {
            LOG.error("Unable to read configuration file", (Throwable)e);
            PEPDaemon.errorAndExit("Unable to read configuration file " + configFilePath, e);
        }
        catch (ConfigurationException e) {
            LOG.error("Unable to load configuration file", (Throwable)e);
            PEPDaemon.errorAndExit("Error parsing configuration file " + configFilePath, (Exception)((Object)e));
        }
        return null;
    }

    private static void errorAndExit(String errorMessage, Exception e) {
        System.err.println(errorMessage);
        if (e != null) {
            System.err.println("This error was caused by the exception:");
            e.printStackTrace(System.err);
        }
        System.out.flush();
        System.exit(1);
    }

    private static void initializeLogging(String loggingConfigFilePath, Timer reloadTasks) {
        LoggingReloadTask reloadTask = null;
        try {
            reloadTask = new LoggingReloadTask(loggingConfigFilePath);
        }
        catch (IOException e) {
            PEPDaemon.errorAndExit("Invalid logging configuration file: " + loggingConfigFilePath, e);
        }
        reloadTask.run();
        reloadTasks.scheduleAtFixedRate((TimerTask)reloadTask, 300000L, 300000L);
    }
}

