/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.server;

import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.util.Strings;
import org.joda.time.DateTime;

@ThreadSafe
public class AuditLogEntry {
    private long requestTime = new DateTime().toDateTimeISO().getMillis();
    private String requestId;
    private String responderId;
    private String responseId;
    private String policyDecision;
    private String errorMessage;

    public AuditLogEntry(String request, String responder, String response, String decision) {
        this.requestId = Strings.safeTrimOrNullString((String)request);
        this.responderId = Strings.safeTrimOrNullString((String)responder);
        this.responseId = Strings.safeTrimOrNullString((String)response);
        this.policyDecision = Strings.safeTrimOrNullString((String)decision);
    }

    public void setErrorMessage(String message) {
        this.errorMessage = Strings.safeTrimOrNullString((String)message);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getPolicyDecision() {
        return this.policyDecision;
    }

    public String getResponderId() {
        return this.responderId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public String getResponseId() {
        return this.responseId;
    }

    public String toString() {
        StringBuilder entryString = new StringBuilder();
        entryString.append(this.getRequestTime());
        entryString.append("|");
        entryString.append(this.getRequestId());
        entryString.append("|");
        entryString.append(this.getResponderId());
        entryString.append("|");
        entryString.append(this.getResponseId());
        entryString.append("|");
        if (this.getPolicyDecision() != null) {
            entryString.append(this.getPolicyDecision());
            entryString.append("|");
        } else {
            entryString.append("Error|");
            if (this.getErrorMessage() != null) {
                entryString.append(this.getErrorMessage());
            }
        }
        return entryString.toString();
    }
}

