/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.config.AbstractConfigurationBuilder;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.IniConfigUtil;
import org.glite.authz.common.config.IniSectionConfigurationParser;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.util.Files;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pep.pip.PolicyInformationPoint;
import org.glite.authz.pep.pip.provider.StaticPIP;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class StaticPIPIniConfigurationParser
implements IniSectionConfigurationParser<PolicyInformationPoint> {
    public static final String CONFIG_FILE_PROP = "staticAttributesFile";
    public static final String DEFAULT_ATTRIBUTE_ISSUER_PROP = "defaultAttributeIssuer";
    public static final String RESOURCE_ATTRIBUTES_IN_ALL_PROP = "includeResourceAttribtuesInAllResources";
    public static final String SUBJECT_ATTRIBUTES_IN_ALL_PROP = "includeSubjectAttribtuesInAllSubjects";
    public static final String ACTION_ATTRIBS_PROP = "actionAttributes";
    public static final String ENVIRONMENT_ATTRIBS_PROP = "environmentAttributes";
    public static final String RESOURCE_ATTRIBS_PROP = "resourceAttributes";
    public static final String SUBJECT_ATTRIBS_PROP = "subjectAttributes";
    public static final String ATTRIBUTE_ID_PROP = "id";
    public static final String ATTRIBUTE_DT_PROP = "datatype";
    public static final String ATTRIBUTE_ISSUER_PROP = "issuer";
    public static final String ATTRIBUTE_VALUE_PROP = "values";
    public static final String ATTRIBUTE_VALUE_DELIM_PROP = "valueDelimiter";
    public static final String DEFAULT_VALUE_DELIM = ",";
    public static final boolean DEFAULT_RESOURCE_ATTRIBUTES_IN_ALL = false;
    public static final boolean DEFAULT_SUBJECT_ATTRIBUTES_IN_ALL = false;
    public static final String DEFAULT_ATTRIBUTE_DT = "http://www.w3.org/2001/XMLSchema#string";
    private Logger log = LoggerFactory.getLogger(StaticPIPIniConfigurationParser.class);

    public PolicyInformationPoint parse(Profile.Section iniConfig, AbstractConfigurationBuilder<?> configBuilder) throws ConfigurationException {
        Ini iniFile = this.readIniFile((String)iniConfig.get((Object)CONFIG_FILE_PROP));
        String pipId = Strings.safeTrimOrNullString((String)iniConfig.getName());
        String defaultAttributeIssuer = Strings.safeTrimOrNullString((String)IniConfigUtil.getString((Profile.Section)iniConfig, (String)DEFAULT_ATTRIBUTE_ISSUER_PROP, null));
        this.log.info("default attribute issuer: {}", (Object)(defaultAttributeIssuer == null ? "none" : defaultAttributeIssuer));
        List<Attribute> actionAttributes = this.parseAttributes(iniFile, IniConfigUtil.getString((Profile.Section)iniConfig, (String)ACTION_ATTRIBS_PROP, null), defaultAttributeIssuer);
        this.log.info("action attributes: {} ", (Object)pipId, actionAttributes);
        List<Attribute> environmentAttributes = this.parseAttributes(iniFile, IniConfigUtil.getString((Profile.Section)iniConfig, (String)ENVIRONMENT_ATTRIBS_PROP, null), defaultAttributeIssuer);
        this.log.info("envrionment attributes: {}", (Object)pipId, environmentAttributes);
        List<Attribute> resourceAttributes = this.parseAttributes(iniFile, IniConfigUtil.getString((Profile.Section)iniConfig, (String)RESOURCE_ATTRIBS_PROP, null), defaultAttributeIssuer);
        this.log.info("resource attributes: {}", (Object)pipId, resourceAttributes);
        List<Attribute> subjectAttributes = this.parseAttributes(iniFile, IniConfigUtil.getString((Profile.Section)iniConfig, (String)SUBJECT_ATTRIBS_PROP, null), defaultAttributeIssuer);
        this.log.info("subject attributes: {}", (Object)pipId, subjectAttributes);
        StaticPIP pip = new StaticPIP(pipId, actionAttributes, environmentAttributes, resourceAttributes, subjectAttributes);
        boolean resourceAttributesInAllResource = IniConfigUtil.getBoolean((Profile.Section)iniConfig, (String)RESOURCE_ATTRIBUTES_IN_ALL_PROP, (boolean)false);
        this.log.info("resource attributes will be applied to all resources in request: {}", (Object)resourceAttributesInAllResource);
        pip.setAddAttributesToAllResources(resourceAttributesInAllResource);
        boolean subjectAttributesInAllSubject = IniConfigUtil.getBoolean((Profile.Section)iniConfig, (String)SUBJECT_ATTRIBUTES_IN_ALL_PROP, (boolean)false);
        this.log.info("subject attributes will be applied to all subject in request: {}", (Object)subjectAttributesInAllSubject);
        pip.setAddAttributesToAllSubjects(subjectAttributesInAllSubject);
        return pip;
    }

    private Ini readIniFile(String filePath) throws ConfigurationException {
        File staticAttributesFile = null;
        try {
            staticAttributesFile = Files.getReadableFile((String)filePath);
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage());
        }
        Ini iniFile = new Ini();
        try {
            iniFile.load((Reader)new FileReader(staticAttributesFile));
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to parse static attribtues file " + filePath, e);
        }
        return iniFile;
    }

    private List<Attribute> parseAttributes(Ini configFile, String attributeSectionNamess, String defaultAttributeIssuer) throws ConfigurationException {
        List sectionNames = Strings.toList((String)attributeSectionNamess, (String)" ");
        if (sectionNames == null) {
            return null;
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Profile.Section configSection = null;
        for (String sectionName : sectionNames) {
            configSection = (Profile.Section)configFile.get((Object)sectionName);
            if (configSection == null) {
                String errorMsg = "INI section " + sectionName + " does not exist but was listed as an attribute definition section";
                this.log.error(errorMsg);
                throw new ConfigurationException(errorMsg);
            }
            attributes.add(this.parseAttributeDefinition(configSection, defaultAttributeIssuer));
        }
        return attributes;
    }

    private Attribute parseAttributeDefinition(Profile.Section configSection, String defaultAttributeIssuer) throws ConfigurationException {
        if (configSection == null) {
            return null;
        }
        Attribute attribute = new Attribute();
        attribute.setId(IniConfigUtil.getString((Profile.Section)configSection, (String)ATTRIBUTE_ID_PROP));
        attribute.setDataType(IniConfigUtil.getString((Profile.Section)configSection, (String)ATTRIBUTE_DT_PROP, (String)DEFAULT_ATTRIBUTE_DT));
        attribute.setIssuer(IniConfigUtil.getString((Profile.Section)configSection, (String)ATTRIBUTE_ISSUER_PROP, (String)defaultAttributeIssuer));
        List values = Strings.toList((String)IniConfigUtil.getString((Profile.Section)configSection, (String)ATTRIBUTE_VALUE_PROP), (String)IniConfigUtil.getString((Profile.Section)configSection, (String)ATTRIBUTE_VALUE_DELIM_PROP, (String)DEFAULT_VALUE_DELIM));
        attribute.getValues().addAll(values);
        this.log.debug("Created the following attribute definition from INI section {}: {}", (Object)configSection.getName(), (Object)attribute);
        return attribute;
    }
}

