/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.model.Action;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.Environment;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Resource;
import org.glite.authz.common.model.Subject;
import org.glite.authz.pep.pip.PIPProcessingException;
import org.glite.authz.pep.pip.provider.AbstractPolicyInformationPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class StaticPIP
extends AbstractPolicyInformationPoint {
    private List<Attribute> actionAttributes;
    private List<Attribute> environmentAttributes;
    private List<Attribute> resourceAttributes;
    private List<Attribute> subjectAttributes;
    private boolean addAttributesToAllResources = false;
    private boolean addAttributesToAllSubjects = false;

    public StaticPIP(String pipId, List<Attribute> action, List<Attribute> environment, List<Attribute> resource, List<Attribute> subject) {
        super(pipId);
        this.actionAttributes = action;
        this.environmentAttributes = environment;
        this.resourceAttributes = resource;
        this.subjectAttributes = subject;
    }

    public boolean isAddAttributesToAllResources() {
        return this.addAttributesToAllResources;
    }

    public void setAddAttributesToAllResources(boolean addAll) {
        this.addAttributesToAllResources = addAll;
    }

    public boolean isAddAttributesToAllSubjects() {
        return this.addAttributesToAllSubjects;
    }

    public void setAddAttributesToAllSubjects(boolean addAll) {
        this.addAttributesToAllSubjects = addAll;
    }

    public boolean populateRequest(Request request) throws PIPProcessingException {
        if (this.actionAttributes != null && !this.actionAttributes.isEmpty()) {
            Action action = request.getAction();
            if (action == null) {
                action = new Action();
                request.setAction(action);
            }
            action.getAttributes().addAll(this.actionAttributes);
        }
        if (this.environmentAttributes != null && !this.environmentAttributes.isEmpty()) {
            Environment environment = request.getEnvironment();
            if (environment == null) {
                environment = new Environment();
                request.setEnvironment(environment);
            }
            environment.getAttributes().addAll(this.environmentAttributes);
        }
        if (this.resourceAttributes != null && !this.resourceAttributes.isEmpty()) {
            Set resources = request.getResources();
            if (resources.size() > 1 && !this.addAttributesToAllResources) {
                throw new PIPProcessingException("More than one Resource present in request and PIP configured to only add attribues to a single Resource");
            }
            if (request.getResources().size() == 0) {
                request.getResources().add(new Resource());
            }
            for (Resource resource : resources) {
                resource.getAttributes().addAll(this.resourceAttributes);
            }
        }
        if (this.subjectAttributes != null && !this.subjectAttributes.isEmpty()) {
            Set subjects = request.getSubjects();
            if (subjects.size() > 1 && !this.addAttributesToAllSubjects) {
                throw new PIPProcessingException("More than one Subject present in request and PIP configured to only add attribues to a single Subject");
            }
            if (request.getSubjects().size() == 0) {
                request.getSubjects().add(new Subject());
            }
            for (Subject subject : subjects) {
                subject.getAttributes().addAll(this.subjectAttributes);
            }
        }
        return true;
    }
}

