/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Subject;
import org.glite.authz.pep.pip.PIPProcessingException;
import org.glite.authz.pep.pip.provider.AbstractX509PIP;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.ac.VOMSACValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCASLegacyPIP
extends AbstractX509PIP {
    public static final String SUBJECT_X509_ID = "http://authz-interop.org/xacml/subject/subject-x509-id";
    public static final String X509_DN_ISSUER = "http://authz-interop.org/xacml/subject/subject-x509-issuer";
    public static final String VOMS_VO = "http://authz-interop.org/xacml/subject/vo";
    public static final String VOMS_SIGNER = "http://authz-interop.org/xacml/subject/voms-signing-subject";
    public static final String VOMS_SIGNER_ISSUER = "http://authz-interop.org/xacml/subject/voms-signing-issuer";
    public static final String VOMS_FQAN = "http://authz-interop.org/xacml/subject/voms-fqan";
    public static final String VOMS_PRIMARY_FQAN = "http://authz-interop.org/xacml/subject/voms-primary-fqan";
    public static final String X509_SN = "http://authz-interop.org/xacml/subject/certificate-serial-number";
    public static final String X509_CA_SN = "http://authz-interop.org/xacml/subject/ca-serial-number";
    public static final String VOMS_DNS_PORT = "http://authz-interop.org/xacml/subject/voms-dns-port";
    public static final String CA_POLICY_OID = "http://authz-interop.org/xacml/subject/ca-policy-oid";
    public static final String X509_CERT_CHAIN_ID = "http://authz-interop.org/xacml/subject/cert-chain";
    public static final String VOMS_GA = "http://authz-interop.org/xacml/subject/generic-attribute";
    private Logger log = LoggerFactory.getLogger(SCASLegacyPIP.class);

    public SCASLegacyPIP(String pipID, boolean requireProxy, X509CertChainValidator x509Validator, VOMSACValidator vomsACValidator) throws ConfigurationException {
        super(pipID, requireProxy, x509Validator, vomsACValidator);
    }

    @Override
    protected String getCertificateAttributeId() {
        return X509_CERT_CHAIN_ID;
    }

    @Override
    protected String getCertificateAttributeDatatype() {
        return "http://www.w3.org/2001/XMLSchema#base64Binary";
    }

    @Override
    protected boolean appliesToRequest(Request request) {
        for (Subject subject : request.getSubjects()) {
            for (Attribute attrib : subject.getAttributes()) {
                if (!X509_CERT_CHAIN_ID.equals(attrib.getId())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Collection<Attribute> processCertChain(X509Certificate endEntityCertificate, X509Certificate[] certChain) throws PIPProcessingException {
        Collection<Attribute> vomsAttributes;
        if (endEntityCertificate == null || certChain == null || certChain.length == 0) {
            return null;
        }
        X509Certificate caCert = null;
        for (X509Certificate cert : certChain) {
            if (!cert.getSubjectX500Principal().equals(endEntityCertificate.getIssuerX500Principal())) continue;
            caCert = cert;
        }
        if (caCert == null) {
            throw new PIPProcessingException("Issuer CA for the end entity certificate was not found in the cert chain");
        }
        this.log.debug("Extracting end-entity certificate attributes");
        HashSet<Attribute> subjectAttributes = new HashSet<Attribute>();
        Attribute attribute = new Attribute();
        attribute.setId(SUBJECT_X509_ID);
        attribute.setDataType("http://www.w3.org/2001/XMLSchema#string");
        String opensslSubject = OpensslNameUtils.convertFromRfc2253((String)endEntityCertificate.getSubjectX500Principal().getName("RFC2253"), (boolean)false);
        attribute.getValues().add(opensslSubject);
        this.log.debug("Extracted attribute: {}", (Object)attribute);
        subjectAttributes.add(attribute);
        attribute = new Attribute();
        attribute.setId(X509_DN_ISSUER);
        attribute.setDataType("http://www.w3.org/2001/XMLSchema#string");
        String opensslIssuer = OpensslNameUtils.convertFromRfc2253((String)endEntityCertificate.getIssuerX500Principal().getName("RFC2253"), (boolean)false);
        attribute.getValues().add(opensslIssuer);
        this.log.debug("Extracted attribute: {}", (Object)attribute);
        subjectAttributes.add(attribute);
        attribute = new Attribute();
        attribute.setId(X509_SN);
        attribute.setDataType("http://www.w3.org/2001/XMLSchema#integer");
        attribute.getValues().add(endEntityCertificate.getSerialNumber().toString());
        this.log.debug("Extracted attribute: {}", (Object)attribute);
        subjectAttributes.add(attribute);
        attribute = new Attribute();
        attribute.setId(X509_CA_SN);
        attribute.setDataType("http://www.w3.org/2001/XMLSchema#integer");
        attribute.getValues().add(caCert.getSerialNumber().toString());
        this.log.debug("Extracted attribute: {}", (Object)attribute);
        subjectAttributes.add(attribute);
        if (this.isVOMSSupportEnabled() && (vomsAttributes = this.processVOMS(endEntityCertificate, certChain)) != null) {
            subjectAttributes.addAll(vomsAttributes);
        }
        return subjectAttributes;
    }

    private Collection<Attribute> processVOMS(X509Certificate endEntityCert, X509Certificate[] certChain) throws PIPProcessingException {
        this.log.debug("Extracting VOMS attribute certificate attributes");
        VOMSAttribute attributeCertificate = this.extractVOMSAttributeCertificate(certChain);
        if (attributeCertificate == null) {
            return null;
        }
        HashSet<Attribute> vomsAttributes = new HashSet<Attribute>();
        Attribute attribute = new Attribute();
        attribute.setId(VOMS_VO);
        attribute.setDataType("http://www.w3.org/2001/XMLSchema#string");
        attribute.getValues().add(attributeCertificate.getVO());
        this.log.debug("Extracted attribute: {}", (Object)attribute);
        vomsAttributes.add(attribute);
        attribute = new Attribute();
        attribute.setId(VOMS_SIGNER);
        attribute.setDataType("http://www.w3.org/2001/XMLSchema#string");
        attribute.getValues().add(attributeCertificate.getIssuer());
        vomsAttributes.add(attribute);
        attribute = new Attribute();
        attribute.setId(VOMS_SIGNER_ISSUER);
        attribute.setDataType("http://www.w3.org/2001/XMLSchema#string");
        String vomsIssuer = OpensslNameUtils.convertFromRfc2253((String)attributeCertificate.getIssuer().getName("RFC2253"), (boolean)false);
        attribute.getValues().add(vomsIssuer);
        vomsAttributes.add(attribute);
        Attribute primaryFqanAttribute = new Attribute();
        primaryFqanAttribute.setId(VOMS_PRIMARY_FQAN);
        primaryFqanAttribute.setDataType("http://www.w3.org/2001/XMLSchema#string");
        primaryFqanAttribute.getValues().add(attributeCertificate.getPrimaryFQAN());
        this.log.debug("Extracted attribute: {}", (Object)primaryFqanAttribute);
        vomsAttributes.add(primaryFqanAttribute);
        List fqans = attributeCertificate.getFQANs();
        if (fqans != null && !fqans.isEmpty()) {
            Attribute fqanAttribute = new Attribute();
            fqanAttribute.setId(VOMS_FQAN);
            fqanAttribute.setDataType("http://www.w3.org/2001/XMLSchema#string");
            for (String fqan : fqans) {
                fqanAttribute.getValues().add(fqan);
            }
            this.log.debug("Extracted attribute: {}", (Object)fqanAttribute);
            vomsAttributes.add(fqanAttribute);
        }
        attribute = new Attribute();
        attribute.setId(VOMS_DNS_PORT);
        attribute.setDataType("http://www.w3.org/2001/XMLSchema#string");
        attribute.getValues().add(attributeCertificate.getHost() + ":" + attributeCertificate.getPort());
        vomsAttributes.add(attribute);
        return vomsAttributes;
    }
}

