/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import org.glite.authz.common.config.AbstractConfigurationBuilder;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.IniConfigUtil;
import org.glite.authz.common.config.IniSectionConfigurationParser;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pep.pip.PolicyInformationPoint;
import org.glite.authz.pep.pip.provider.RequestValidatorPIP;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestValidatorPIPIniConfigurationParser
implements IniSectionConfigurationParser<PolicyInformationPoint> {
    private Logger log = LoggerFactory.getLogger(RequestValidatorPIPIniConfigurationParser.class);
    public static final String VALIDATE_REQUEST_SUBJECTS_PROP = "validateRequestSubjects";
    public static final String VALIDATE_REQUEST_RESOURCES_PROP = "validateRequestResources";
    public static final String VALIDATE_REQUEST_ACTION_PROP = "validateRequestAction";
    public static final String VALIDATE_REQUEST_ENVIRONMENT_PROP = "validateRequestEnvironment";
    public static boolean DEFAULT_VALIDATE_REQUEST_SUBJECTS = true;
    public static boolean DEFAULT_VALIDATE_REQUEST_RESOURCES = true;
    public static boolean DEFAULT_VALIDATE_REQUEST_ACTION = true;
    public static boolean DEFAULT_VALIDATE_REQUEST_ENVIRONMENT = false;

    public PolicyInformationPoint parse(Profile.Section iniConfig, AbstractConfigurationBuilder<?> configBuilder) throws ConfigurationException {
        String pipid = Strings.safeTrimOrNullString((String)iniConfig.getName());
        RequestValidatorPIP pip = new RequestValidatorPIP(pipid);
        boolean validateRequestSubjects = IniConfigUtil.getBoolean((Profile.Section)iniConfig, (String)VALIDATE_REQUEST_SUBJECTS_PROP, (boolean)DEFAULT_VALIDATE_REQUEST_SUBJECTS);
        this.log.info("{}: validate request subjects: {}", (Object)pipid, (Object)validateRequestSubjects);
        pip.setValidateRequestSubjects(validateRequestSubjects);
        boolean validateRequestResources = IniConfigUtil.getBoolean((Profile.Section)iniConfig, (String)VALIDATE_REQUEST_RESOURCES_PROP, (boolean)DEFAULT_VALIDATE_REQUEST_RESOURCES);
        this.log.info("{}: validate request resources: {}", (Object)pipid, (Object)validateRequestResources);
        pip.setValidateRequestResources(validateRequestResources);
        boolean validateRequestAction = IniConfigUtil.getBoolean((Profile.Section)iniConfig, (String)VALIDATE_REQUEST_ACTION_PROP, (boolean)DEFAULT_VALIDATE_REQUEST_ACTION);
        this.log.info("{}: validate request action: {}", (Object)pipid, (Object)validateRequestAction);
        pip.setValidateRequestAction(validateRequestAction);
        boolean validateRequestEnvironment = IniConfigUtil.getBoolean((Profile.Section)iniConfig, (String)VALIDATE_REQUEST_ENVIRONMENT_PROP, (boolean)DEFAULT_VALIDATE_REQUEST_ENVIRONMENT);
        this.log.info("{}: validate request environment: {}", (Object)pipid, (Object)validateRequestEnvironment);
        pip.setValidateRequestEnvironment(validateRequestEnvironment);
        return pip;
    }
}

