/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import java.util.Set;
import org.glite.authz.common.model.Action;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.Environment;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Resource;
import org.glite.authz.common.model.Subject;
import org.glite.authz.common.model.util.Strings;
import org.glite.authz.pep.pip.PIPProcessingException;
import org.glite.authz.pep.pip.provider.AbstractPolicyInformationPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestValidatorPIP
extends AbstractPolicyInformationPoint {
    private boolean validateRequestSubjects_ = true;
    private boolean validateRequestResources_ = true;
    private boolean validateRequestAction_ = true;
    private boolean validateRequestEnvironment_ = false;

    public RequestValidatorPIP(String pipid) {
        super(pipid);
    }

    public boolean populateRequest(Request request) throws PIPProcessingException, IllegalStateException {
        boolean applied = false;
        if (this.validateRequestSubjects_) {
            applied = true;
            Set subjects = request.getSubjects();
            if (subjects.size() < 1) {
                throw new PIPProcessingException("Decision request does not contain any Subject");
            }
            for (Subject subject : subjects) {
                this.validateAttributes(subject.getAttributes(), "Subject");
            }
        }
        if (this.validateRequestResources_) {
            applied = true;
            Set resources = request.getResources();
            if (resources.size() < 1) {
                throw new PIPProcessingException("Decision request does not contain any Resource");
            }
            for (Resource resource : resources) {
                this.validateAttributes(resource.getAttributes(), "Resource");
            }
        }
        if (this.validateRequestAction_) {
            applied = true;
            Action action = request.getAction();
            if (action == null) {
                throw new PIPProcessingException("Decision request does not contain an Action");
            }
            this.validateAttributes(action.getAttributes(), "Action");
        }
        if (this.validateRequestEnvironment_) {
            applied = true;
            Environment environment = request.getEnvironment();
            if (environment == null) {
                throw new PIPProcessingException("Decision request does not contain an Environment");
            }
            this.validateAttributes(environment.getAttributes(), "Environment");
        }
        return applied;
    }

    protected void setValidateRequestSubjects(boolean validateRequestSubjects) {
        this.validateRequestSubjects_ = validateRequestSubjects;
    }

    protected void setValidateRequestResources(boolean validateRequestResources) {
        this.validateRequestResources_ = validateRequestResources;
    }

    protected void setValidateRequestAction(boolean validateRequestAction) {
        this.validateRequestAction_ = validateRequestAction;
    }

    protected void setValidateRequestEnvironment(boolean validateRequestEnvironment) {
        this.validateRequestEnvironment_ = validateRequestEnvironment;
    }

    private void validateAttributes(Set<Attribute> attributes, String element) throws PIPProcessingException {
        if (attributes.size() < 1) {
            throw new PIPProcessingException("Decision request " + element + " without any attribute");
        }
        for (Attribute attribute : attributes) {
            Set attributeValues = attribute.getValues();
            if (attributeValues.size() < 1) {
                throw new PIPProcessingException("Decision request " + element + " contains the attribute " + attribute.getId() + " without any value");
            }
            for (Object attributeValue : attributeValues) {
                if (attributeValue == null) {
                    throw new PIPProcessingException("Decision request " + element + " contains the attribute " + attribute.getId() + " with a null value");
                }
                String value = Strings.safeTrimOrNullString((String)attributeValue.toString());
                if (value != null) continue;
                throw new PIPProcessingException("Decision request " + element + " contains the attribute " + attribute.getId() + " with an empty (stripped) value");
            }
        }
    }
}

