/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import java.util.Arrays;
import java.util.List;
import org.glite.authz.common.config.AbstractConfigurationBuilder;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.IniConfigUtil;
import org.glite.authz.common.config.IniSectionConfigurationParser;
import org.glite.authz.pep.pip.PolicyInformationPoint;
import org.glite.authz.pep.pip.provider.OpenSSLSubjectPIP;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSSLSubjectPIPIniConfigurationParser
implements IniSectionConfigurationParser<PolicyInformationPoint> {
    private Logger log = LoggerFactory.getLogger(OpenSSLSubjectPIPIniConfigurationParser.class);
    public static final String OPENSSL_SUBJECT_ATTIBUTE_IDS_PROP = "opensslSubjectAttributeIDs";
    public static final String OPENSSL_SUBJECT_ATTIBUTE_DATATYPES_PROP = "opensslSubjectAttributeDatatypes";

    public PolicyInformationPoint parse(Profile.Section iniConfig, AbstractConfigurationBuilder<?> configBuilder) throws ConfigurationException {
        String pipid = iniConfig.getName();
        OpenSSLSubjectPIP pip = new OpenSSLSubjectPIP(pipid);
        List<String> subjectAttributeIDs = null;
        try {
            String[] opensslSubjectAttributeIDs = IniConfigUtil.getStringsArray((Profile.Section)iniConfig, (String)OPENSSL_SUBJECT_ATTIBUTE_IDS_PROP);
            subjectAttributeIDs = Arrays.asList(opensslSubjectAttributeIDs);
        }
        catch (ConfigurationException e) {
            subjectAttributeIDs = OpenSSLSubjectPIP.DEFAULT_OPENSSL_SUBJECT_ATTRIBUTE_IDS;
        }
        this.log.info("{}: OpenSSL subject attributes IDs to convert: {}", (Object)pipid, subjectAttributeIDs);
        pip.setSubjectAttributeIDs(subjectAttributeIDs);
        List<String> subjectAttributeDatatypes = null;
        try {
            String[] opensslSubjectAttributeDatatypes = IniConfigUtil.getStringsArray((Profile.Section)iniConfig, (String)OPENSSL_SUBJECT_ATTIBUTE_DATATYPES_PROP);
            subjectAttributeDatatypes = Arrays.asList(opensslSubjectAttributeDatatypes);
        }
        catch (ConfigurationException e) {
            subjectAttributeDatatypes = OpenSSLSubjectPIP.DEFAULT_OPENSSL_SUBJECT_ATTRIBUTE_DATATYPES;
        }
        this.log.info("{}: OpenSSL subject attributes datatypes to convert: {}", (Object)pipid, subjectAttributeDatatypes);
        pip.setSubjectAttributeDataTypes(subjectAttributeDatatypes);
        return pip;
    }
}

