/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import java.util.Arrays;
import java.util.List;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Subject;
import org.glite.authz.common.util.LazyList;
import org.glite.authz.pep.pip.PIPProcessingException;
import org.glite.authz.pep.pip.provider.AbstractPolicyInformationPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenSSLSubjectPIP
extends AbstractPolicyInformationPoint {
    private final Logger log = LoggerFactory.getLogger(OpenSSLSubjectPIP.class);
    public static final List<String> DEFAULT_OPENSSL_SUBJECT_ATTRIBUTE_IDS = Arrays.asList("http://glite.org/xacml/attribute/subject-issuer", "urn:oasis:names:tc:xacml:1.0:subject:subject-id");
    public static final List<String> DEFAULT_OPENSSL_SUBJECT_ATTRIBUTE_DATATYPES = Arrays.asList("http://www.w3.org/2001/XMLSchema#string");
    private List<String> subjectAttributeIDs_ = DEFAULT_OPENSSL_SUBJECT_ATTRIBUTE_IDS;
    private List<String> subjectAttributeDataTypes_ = DEFAULT_OPENSSL_SUBJECT_ATTRIBUTE_DATATYPES;

    public OpenSSLSubjectPIP(String pipid) {
        super(pipid);
    }

    public boolean populateRequest(Request request) throws PIPProcessingException {
        boolean applied = false;
        for (Subject subject : request.getSubjects()) {
            LazyList rfcAttributes = new LazyList();
            for (Attribute attribute : subject.getAttributes()) {
                if (!this.subjectAttributeDataTypes_.contains(attribute.getDataType()) || !this.subjectAttributeIDs_.contains(attribute.getId())) continue;
                applied = true;
                Attribute rfcAttribute = new Attribute(attribute.getId(), "urn:oasis:names:tc:xacml:1.0:data-type:x500Name", attribute.getIssuer());
                for (Object value : attribute.getValues()) {
                    String opensslDN = value.toString();
                    String rfcDN = OpensslNameUtils.opensslToRfc2253((String)opensslDN);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("OpenSSL DN {} converted to {}", (Object)opensslDN, (Object)rfcDN);
                    }
                    rfcAttribute.getValues().add(rfcDN);
                }
                rfcAttributes.add(rfcAttribute);
            }
            if (rfcAttributes.isEmpty()) continue;
            subject.getAttributes().addAll(rfcAttributes);
        }
        return applied;
    }

    protected void setSubjectAttributeIDs(List<String> subjectAttributeIDs) {
        this.subjectAttributeIDs_ = subjectAttributeIDs;
    }

    protected void setSubjectAttributeDataTypes(List<String> subjectAttributeDataTypes) {
        this.subjectAttributeDataTypes_ = subjectAttributeDataTypes;
    }
}

