/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import eu.emi.security.authn.x509.X509CertChainValidator;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.Environment;
import org.glite.authz.common.model.Request;
import org.glite.authz.pep.pip.PIPProcessingException;
import org.glite.authz.pep.pip.provider.AbstractX509PIP;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.ac.VOMSACValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLiteAuthorizationProfilePIP
extends AbstractX509PIP {
    private List<String> acceptedProfileIds_ = null;
    private Logger log = LoggerFactory.getLogger(GLiteAuthorizationProfilePIP.class);

    public GLiteAuthorizationProfilePIP(String pipID, boolean requireProxy, X509CertChainValidator x509Validator, VOMSACValidator vomsACValidator, boolean performPKIXValidation) throws ConfigurationException {
        super(pipID, requireProxy, x509Validator, vomsACValidator);
        this.performPKIXValidation(performPKIXValidation);
    }

    public GLiteAuthorizationProfilePIP(String pipID, boolean requireProxy, X509CertChainValidator x509Validator, VOMSACValidator vomsACValidator, boolean performPKIXValidation, String[] acceptedProfileIds) throws ConfigurationException {
        this(pipID, requireProxy, x509Validator, vomsACValidator, performPKIXValidation);
        if (acceptedProfileIds == null) {
            this.log.debug("{}: accept all profile ID values", (Object)pipID);
            this.acceptedProfileIds_ = null;
        } else if (acceptedProfileIds.length == 0) {
            this.log.debug("{}: accept NO profile ID value", (Object)pipID);
            this.acceptedProfileIds_ = Collections.emptyList();
        } else {
            this.log.debug("{}: accept profile ID values: ", (Object)pipID, (Object)Arrays.toString(acceptedProfileIds));
            this.acceptedProfileIds_ = new ArrayList<String>(Arrays.asList(acceptedProfileIds));
        }
    }

    @Override
    protected boolean appliesToRequest(Request request) {
        Environment env = request.getEnvironment();
        if (env != null) {
            for (Attribute attrib : env.getAttributes()) {
                if (!"http://glite.org/xacml/attribute/profile-id".equals(attrib.getId())) continue;
                if (this.acceptedProfileIds_ == null) {
                    this.log.trace("PIP '{}' accept all {} value", (Object)this.getId(), (Object)"http://glite.org/xacml/attribute/profile-id");
                    return true;
                }
                if (this.acceptedProfileIds_.isEmpty()) {
                    this.log.warn("PIP '{}' don't accept any profile ID, specify 'acceptedProfileIDs = ...' in config.", (Object)this.getId());
                    return false;
                }
                for (String acceptedProfileId : this.acceptedProfileIds_) {
                    if (!attrib.getValues().contains(acceptedProfileId)) continue;
                    this.log.trace("PIP '{}' accept {}", (Object)this.getId(), (Object)acceptedProfileId);
                    return true;
                }
                this.log.debug("PIP '{}' don't accept profile ID: {}", (Object)this.getId(), (Object)attrib.getValues());
                return false;
            }
        }
        this.log.debug("Skipping PIP '{}', request does not contain a profile identifier in environment", (Object)this.getId());
        return false;
    }

    @Override
    protected String getCertificateAttributeId() {
        return "urn:oasis:names:tc:xacml:1.0:subject:key-info";
    }

    @Override
    protected String getCertificateAttributeDatatype() {
        return "http://www.w3.org/2001/XMLSchema#string";
    }

    @Override
    protected Collection<Attribute> processCertChain(X509Certificate endEntityCertificate, X509Certificate[] certChain) throws PIPProcessingException {
        Collection<Attribute> vomsAttributes;
        if (endEntityCertificate == null || certChain == null || certChain.length == 0) {
            return null;
        }
        this.log.debug("Extracting end-entity certificate attributes");
        HashSet<Attribute> subjectAttributes = new HashSet<Attribute>();
        String endEntitySubjectDN = endEntityCertificate.getSubjectX500Principal().getName("RFC2253");
        Attribute attribute = new Attribute();
        attribute.setId("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
        attribute.setDataType("urn:oasis:names:tc:xacml:1.0:data-type:x500Name");
        attribute.getValues().add(endEntitySubjectDN);
        this.log.debug("Extracted subject-id attribute: {}", (Object)attribute);
        subjectAttributes.add(attribute);
        attribute = new Attribute();
        attribute.setId("http://glite.org/xacml/attribute/subject-issuer");
        attribute.setDataType("urn:oasis:names:tc:xacml:1.0:data-type:x500Name");
        for (X509Certificate cert : certChain) {
            String issuer = cert.getIssuerX500Principal().getName("RFC2253");
            attribute.getValues().add(issuer);
        }
        this.log.debug("Extracted subject-issuer attribute: {}", (Object)attribute);
        subjectAttributes.add(attribute);
        if (this.isVOMSSupportEnabled() && (vomsAttributes = this.processVOMS(endEntityCertificate, certChain)) != null) {
            subjectAttributes.addAll(vomsAttributes);
        }
        return subjectAttributes;
    }

    private Collection<Attribute> processVOMS(X509Certificate endEntityCert, X509Certificate[] certChain) throws PIPProcessingException {
        this.log.debug("Extracting VOMS attribute certificate attributes");
        VOMSAttribute attributeCertificate = this.extractVOMSAttributeCertificate(certChain);
        if (attributeCertificate == null) {
            return null;
        }
        HashSet<Attribute> vomsAttributes = new HashSet<Attribute>();
        Attribute voAttribute = new Attribute();
        voAttribute.setId("http://glite.org/xacml/attribute/virtual-organization");
        voAttribute.setDataType("http://www.w3.org/2001/XMLSchema#string");
        voAttribute.getValues().add(attributeCertificate.getVO());
        this.log.debug("Extracted virtual-organization attribute: {}", (Object)voAttribute);
        vomsAttributes.add(voAttribute);
        String primaryFqan = attributeCertificate.getPrimaryFQAN();
        Attribute primaryFqanAttribute = new Attribute();
        primaryFqanAttribute.setId("http://glite.org/xacml/attribute/fqan/primary");
        primaryFqanAttribute.setDataType("http://glite.org/xacml/datatype/fqan");
        primaryFqanAttribute.getValues().add(primaryFqan);
        this.log.debug("Extracted fqan/primary attribute: {}", (Object)primaryFqanAttribute);
        vomsAttributes.add(primaryFqanAttribute);
        List fqans = attributeCertificate.getFQANs();
        if (!fqans.isEmpty()) {
            Attribute fqanAttribute = new Attribute();
            fqanAttribute.setId("http://glite.org/xacml/attribute/fqan");
            fqanAttribute.setDataType("http://glite.org/xacml/datatype/fqan");
            for (String fqan : fqans) {
                fqanAttribute.getValues().add(fqan);
            }
            this.log.debug("Extracted fqan attribute: {}", (Object)fqanAttribute);
            vomsAttributes.add(fqanAttribute);
        }
        return vomsAttributes;
    }
}

