/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import org.glite.authz.common.config.AbstractConfigurationBuilder;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.IniConfigUtil;
import org.glite.authz.common.config.IniSectionConfigurationParser;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pep.pip.PolicyInformationPoint;
import org.glite.authz.pep.pip.provider.EnvironmentTimePIP;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentTimePIPIniConfigurationParser
implements IniSectionConfigurationParser<PolicyInformationPoint> {
    public static final String USE_UTC_TIMEZONE_PROP = "useUTCTimeZone";
    public static final boolean DEFAULT_USE_UTC_TIMEZONE = true;
    private Logger log = LoggerFactory.getLogger(EnvironmentTimePIP.class);

    public PolicyInformationPoint parse(Profile.Section iniConfig, AbstractConfigurationBuilder<?> configBuilder) throws ConfigurationException {
        String pipid = Strings.safeTrimOrNullString((String)iniConfig.getName());
        EnvironmentTimePIP pip = new EnvironmentTimePIP(pipid);
        boolean useUTC = IniConfigUtil.getBoolean((Profile.Section)iniConfig, (String)USE_UTC_TIMEZONE_PROP, (boolean)true);
        this.log.info("{}: uses UTC time zone: {}", (Object)pipid, (Object)useUTC);
        pip.setUTC(useUTC);
        return pip;
    }
}

