/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.Environment;
import org.glite.authz.common.model.Request;
import org.glite.authz.pep.pip.PIPProcessingException;
import org.glite.authz.pep.pip.provider.AbstractPolicyInformationPoint;

@ThreadSafe
public class EnvironmentTimePIP
extends AbstractPolicyInformationPoint {
    public static final String CURRENT_TIME_ATTRIB_NAME = "urn:oasis:names:tc:xacml:1.0:environment:current-time";
    public static final String CURRENT_DATE_ATTRIB_NAME = "urn:oasis:names:tc:xacml:1.0:environment:current-date";
    public static final String CURRENT_DATETIME_ATTRIB_NAME = "urn:oasis:names:tc:xacml:1.0:environment:current-dateTime";
    private DatatypeFactory xmlCalendarFactory;
    private boolean useUTC = true;

    public EnvironmentTimePIP(String pipId) {
        super(pipId);
        try {
            this.xmlCalendarFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("JAXP provider does not provide a complete JAXP 1.3 implementation", e);
        }
    }

    public void setUTC(boolean useUTC) {
        this.useUTC = useUTC;
    }

    public boolean populateRequest(Request request) throws PIPProcessingException {
        Environment environment = request.getEnvironment();
        if (environment == null) {
            environment = new Environment();
            request.setEnvironment(environment);
        }
        GregorianCalendar now = null;
        now = this.useUTC ? new GregorianCalendar(TimeZone.getTimeZone("UTC")) : new GregorianCalendar();
        XMLGregorianCalendar currentTime = this.xmlCalendarFactory.newXMLGregorianCalendar(now);
        currentTime.setYear(Integer.MIN_VALUE);
        currentTime.setMonth(Integer.MIN_VALUE);
        currentTime.setDay(Integer.MIN_VALUE);
        currentTime.setMillisecond(Integer.MIN_VALUE);
        Attribute currentTimeAttribute = new Attribute();
        currentTimeAttribute.setId(CURRENT_TIME_ATTRIB_NAME);
        currentTimeAttribute.setDataType("http://www.w3.org/2001/XMLSchema#time");
        currentTimeAttribute.getValues().add(currentTime.toXMLFormat());
        environment.getAttributes().add(currentTimeAttribute);
        XMLGregorianCalendar currentDate = this.xmlCalendarFactory.newXMLGregorianCalendar(now);
        currentDate.setHour(Integer.MIN_VALUE);
        currentDate.setMinute(Integer.MIN_VALUE);
        currentDate.setSecond(Integer.MIN_VALUE);
        currentDate.setMillisecond(Integer.MIN_VALUE);
        currentDate.setTimezone(Integer.MIN_VALUE);
        Attribute currentDateAttribute = new Attribute();
        currentDateAttribute.setId(CURRENT_DATE_ATTRIB_NAME);
        currentDateAttribute.setDataType("http://www.w3.org/2001/XMLSchema#date");
        currentDateAttribute.getValues().add(currentDate.toXMLFormat());
        environment.getAttributes().add(currentDateAttribute);
        XMLGregorianCalendar currentDateTime = this.xmlCalendarFactory.newXMLGregorianCalendar(now);
        currentDateTime.setMillisecond(Integer.MIN_VALUE);
        Attribute currentDateTimeAttribute = new Attribute();
        currentDateTimeAttribute.setId(CURRENT_DATETIME_ATTRIB_NAME);
        currentDateTimeAttribute.setDataType("http://www.w3.org/2001/XMLSchema#dateTime");
        currentDateTimeAttribute.getValues().add(currentDateTime.toXMLFormat());
        environment.getAttributes().add(currentDateTimeAttribute);
        return true;
    }
}

