/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import eu.emi.security.authn.x509.X509CertChainValidator;
import java.util.ArrayList;
import java.util.Arrays;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pep.pip.PolicyInformationPoint;
import org.glite.authz.pep.pip.provider.AbstractX509PIPIniConfigurationParser;
import org.glite.authz.pep.pip.provider.CommonXACMLAuthorizationProfilePIP;
import org.ini4j.Profile;
import org.italiangrid.voms.ac.VOMSACValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonXACMLAuthorizationProfilePIPIniConfigurationParser
extends AbstractX509PIPIniConfigurationParser {
    private Logger log = LoggerFactory.getLogger(CommonXACMLAuthorizationProfilePIPIniConfigurationParser.class);
    public static String ACCEPTED_PROFILE_IDS_PROP = "acceptedProfileIDs";

    protected PolicyInformationPoint buildInformationPoint(Profile.Section iniConfig, boolean requireProxy, X509CertChainValidator x509Validator, VOMSACValidator vomsACValidator, boolean performPKIXValidation, boolean requireCertificate) throws ConfigurationException {
        String pipId = iniConfig.getName();
        Object[] acceptedProfileIds = this.parseValuesList((String)iniConfig.get((Object)ACCEPTED_PROFILE_IDS_PROP));
        if (acceptedProfileIds != null && acceptedProfileIds.length > 0) {
            this.log.info("{}: accepted profile IDs: {}", (Object)pipId, (Object)Arrays.toString(acceptedProfileIds));
        } else {
            this.log.info("{}: accepted profile IDs: all", (Object)pipId);
        }
        CommonXACMLAuthorizationProfilePIP pip = new CommonXACMLAuthorizationProfilePIP(pipId, requireProxy, x509Validator, vomsACValidator, performPKIXValidation, (String[])acceptedProfileIds);
        pip.setRequireCertificate(requireCertificate);
        return pip;
    }

    protected boolean getRequireCertificateDefault() {
        return false;
    }

    private String[] parseValuesList(String valuesList) {
        if (valuesList == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (String value : valuesList.split(" ")) {
            String trimmedValue = Strings.safeTrimOrNullString((String)value);
            if (trimmedValue == null) continue;
            values.add(trimmedValue);
        }
        return values.toArray(new String[values.size()]);
    }
}

