/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.fqan.FQAN;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.Environment;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Subject;
import org.glite.authz.common.util.Base64;
import org.glite.authz.common.util.LazyList;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pep.pip.PIPProcessingException;
import org.glite.authz.pep.pip.provider.AbstractX509PIP;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.ac.VOMSACValidator;
import org.italiangrid.voms.ac.VOMSValidationResult;
import org.italiangrid.voms.error.VOMSValidationErrorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonXACMLAuthorizationProfilePIP
extends AbstractX509PIP {
    private List<String> acceptedProfileIds_ = null;
    private Logger log = LoggerFactory.getLogger(CommonXACMLAuthorizationProfilePIP.class);
    private CertificateFactory cf_;
    private static final String NULL_STRING = "NULL";

    public CommonXACMLAuthorizationProfilePIP(String pipID, boolean requireProxy, X509CertChainValidator x509Validator, VOMSACValidator vomsACValidator, boolean performPKIXValidation) throws ConfigurationException {
        super(pipID, requireProxy, x509Validator, vomsACValidator);
        this.performPKIXValidation(performPKIXValidation);
        try {
            this.cf_ = CertificateFactory.getInstance("X.509", Security.getProvider(BouncyCastleProvider.PROVIDER_NAME));
        }
        catch (CertificateException e) {
            throw new ConfigurationException("Fail to get instance of the X.509 certificate factory", (Exception)e);
        }
    }

    public CommonXACMLAuthorizationProfilePIP(String pipID, boolean requireProxy, X509CertChainValidator x509Validator, VOMSACValidator vomsACValidator, boolean performPKIXValidation, String[] acceptedProfileIds) throws ConfigurationException {
        this(pipID, requireProxy, x509Validator, vomsACValidator, performPKIXValidation);
        if (acceptedProfileIds == null) {
            this.log.debug("{}: accept all profile ID values", (Object)pipID);
            this.acceptedProfileIds_ = null;
        } else if (acceptedProfileIds.length == 0) {
            this.log.debug("{}: accept NO profile ID value", (Object)pipID);
            this.acceptedProfileIds_ = Collections.emptyList();
        } else {
            this.log.debug("{}: accept profile ID values: ", (Object)pipID, (Object)Arrays.toString(acceptedProfileIds));
            this.acceptedProfileIds_ = new ArrayList<String>(Arrays.asList(acceptedProfileIds));
        }
    }

    @Override
    protected boolean appliesToRequest(Request request) {
        Environment env = request.getEnvironment();
        if (env != null) {
            for (Attribute attrib : env.getAttributes()) {
                if (!"http://dci-sec.org/xacml/attribute/profile-id".equals(attrib.getId())) continue;
                if (this.acceptedProfileIds_ == null) {
                    this.log.trace("PIP '{}' accept all {} value", (Object)this.getId(), (Object)"http://dci-sec.org/xacml/attribute/profile-id");
                    return true;
                }
                if (this.acceptedProfileIds_.isEmpty()) {
                    this.log.warn("PIP '{}' don't accept any profile ID, specify 'acceptedProfileIDs = ...' in config.", (Object)this.getId());
                    return false;
                }
                for (String acceptedProfileId : this.acceptedProfileIds_) {
                    if (!attrib.getValues().contains(acceptedProfileId)) continue;
                    this.log.trace("PIP '{}' accept {}", (Object)this.getId(), (Object)acceptedProfileId);
                    return true;
                }
                this.log.debug("PIP '{}' don't accept profile ID: {}", (Object)this.getId(), (Object)attrib.getValues());
                return false;
            }
        }
        this.log.debug("Skipping PIP '{}', request does not contain a profile identifier in environment", (Object)this.getId());
        return false;
    }

    @Override
    protected String getCertificateAttributeId() {
        return "urn:oasis:names:tc:xacml:1.0:subject:key-info";
    }

    @Override
    protected String getCertificateAttributeDatatype() {
        return "http://www.w3.org/2001/XMLSchema#base64Binary";
    }

    @Override
    protected Collection<Attribute> processCertChain(X509Certificate endEntityCertificate, X509Certificate[] certChain) throws PIPProcessingException {
        Collection<Attribute> vomsAttributes;
        if (endEntityCertificate == null || certChain == null || certChain.length == 0) {
            return null;
        }
        this.log.debug("Extracting EEC attributes...");
        HashSet<Attribute> subjectAttributes = new HashSet<Attribute>();
        String endEntitySubjectDN = endEntityCertificate.getSubjectX500Principal().getName("RFC2253");
        Attribute subjectIdAttribute = new Attribute("urn:oasis:names:tc:xacml:1.0:subject:subject-id", "urn:oasis:names:tc:xacml:1.0:data-type:x500Name");
        subjectIdAttribute.getValues().add(endEntitySubjectDN);
        this.log.debug("subject-id attribute: {}", (Object)subjectIdAttribute);
        subjectAttributes.add(subjectIdAttribute);
        Attribute subjectIssuerAttribute = new Attribute("http://dci-sec.org/xacml/attribute/subject-issuer", "urn:oasis:names:tc:xacml:1.0:data-type:x500Name");
        for (X509Certificate cert : certChain) {
            String issuer = cert.getIssuerX500Principal().getName("RFC2253");
            subjectIssuerAttribute.getValues().add(issuer);
        }
        this.log.debug("subject-issuer attribute: {}", (Object)subjectIssuerAttribute);
        subjectAttributes.add(subjectIssuerAttribute);
        if (this.isVOMSSupportEnabled() && (vomsAttributes = this.processVOMS(certChain)) != null) {
            subjectAttributes.addAll(vomsAttributes);
        }
        return subjectAttributes;
    }

    protected Collection<Attribute> processVOMS(X509Certificate[] certChain) {
        this.log.debug("Extracting VOMS ACs");
        List<VOMSAttribute> vomsAttributes = this.extractVOMSAttributes(certChain);
        if (vomsAttributes == null) {
            this.log.debug("No VOMS AC found in cert chain");
            return null;
        }
        HashSet<Attribute> vomsSubjectAttributes = new HashSet<Attribute>();
        Attribute voAttribute = new Attribute();
        voAttribute.setId("http://dci-sec.org/xacml/attribute/virtual-organization");
        voAttribute.setDataType("http://www.w3.org/2001/XMLSchema#string");
        Attribute primaryGroupAttribute = new Attribute("http://dci-sec.org/xacml/attribute/group/primary", "http://www.w3.org/2001/XMLSchema#string");
        Attribute primaryRoleAttribute = null;
        Attribute groupAttribute = new Attribute("http://dci-sec.org/xacml/attribute/group", "http://www.w3.org/2001/XMLSchema#string");
        Hashtable<String, Attribute> issuerRoleAttributeHT = new Hashtable<String, Attribute>();
        boolean primaryGroupRole = true;
        for (VOMSAttribute vomsAttribute : vomsAttributes) {
            String voName = vomsAttribute.getVO();
            voAttribute.getValues().add(voName);
            List fqans = vomsAttribute.getFQANs();
            for (String fqanString : fqans) {
                FQAN fqan;
                try {
                    fqan = FQAN.parseFQAN((String)fqanString);
                }
                catch (ParseException e) {
                    this.log.warn("Failed to parse FQAN: {}. {}", (Object)fqanString, (Object)e.getMessage());
                    continue;
                }
                String groupName = fqan.getGroupName();
                groupAttribute.getValues().add(groupName);
                String roleName = fqan.getRole();
                if (!CommonXACMLAuthorizationProfilePIP.isNullorNULL(roleName)) {
                    Attribute roleAttribute = (Attribute)issuerRoleAttributeHT.get(groupName);
                    if (roleAttribute == null) {
                        roleAttribute = new Attribute("http://dci-sec.org/xacml/attribute/role", "http://www.w3.org/2001/XMLSchema#string", groupName);
                        issuerRoleAttributeHT.put(groupName, roleAttribute);
                    }
                    roleAttribute.getValues().add(roleName);
                }
                if (!primaryGroupRole) continue;
                primaryGroupAttribute.getValues().add(groupName);
                if (!CommonXACMLAuthorizationProfilePIP.isNullorNULL(roleName)) {
                    primaryRoleAttribute = new Attribute("http://dci-sec.org/xacml/attribute/role/primary", "http://www.w3.org/2001/XMLSchema#string", groupName);
                    primaryRoleAttribute.getValues().add(roleName);
                }
                primaryGroupRole = false;
            }
        }
        this.log.debug("VO attribute: {}", (Object)voAttribute);
        vomsSubjectAttributes.add(voAttribute);
        this.log.debug("Primary group attribute: {}", (Object)primaryGroupAttribute);
        vomsSubjectAttributes.add(primaryGroupAttribute);
        this.log.debug("Group attribute: {}", (Object)groupAttribute);
        vomsSubjectAttributes.add(groupAttribute);
        if (primaryRoleAttribute != null) {
            this.log.debug("Primary role attribute: {}", primaryRoleAttribute);
            vomsSubjectAttributes.add(primaryRoleAttribute);
        }
        if (!issuerRoleAttributeHT.isEmpty()) {
            Collection roleAttributes = issuerRoleAttributeHT.values();
            this.log.debug("Role attributes: {}", roleAttributes);
            vomsSubjectAttributes.addAll(roleAttributes);
        }
        return vomsSubjectAttributes;
    }

    private List<VOMSAttribute> extractVOMSAttributes(X509Certificate[] certChain) {
        VOMSACValidator validator = this.getVOMSACValidator();
        String x509Subject = certChain[0].getSubjectX500Principal().getName("RFC2253");
        this.log.debug("Validating VOMS AC for {}", (Object)x509Subject);
        List results = validator.validateWithResult(certChain);
        if (results.isEmpty()) {
            this.log.warn("No VOMS attributes found in cert chain: {}", (Object)x509Subject);
            return null;
        }
        LazyList vomsAttributes = new LazyList();
        for (VOMSValidationResult result : results) {
            if (result.isValid()) {
                vomsAttributes.add(result.getAttributes());
                continue;
            }
            List errorMessages = result.getValidationErrors();
            Iterator i$ = errorMessages.iterator();
            if (!i$.hasNext()) continue;
            VOMSValidationErrorMessage errorMessage = (VOMSValidationErrorMessage)i$.next();
            this.log.error("VOMS validation fails: " + errorMessage.getMessage());
            return null;
        }
        if (vomsAttributes.isEmpty()) {
            this.log.warn("No valid VOMS attributes found in cert chain: {}", (Object)x509Subject);
            return null;
        }
        return vomsAttributes;
    }

    @Override
    protected X509Certificate[] extractCertificateChain(Subject subject) throws PIPProcessingException {
        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
        for (Attribute attribute : subject.getAttributes()) {
            if (!Strings.safeEquals((Object)attribute.getId(), (Object)this.getCertificateAttributeId()) || !Strings.safeEquals((Object)attribute.getDataType(), (Object)this.getCertificateAttributeDatatype())) continue;
            for (Object value : attribute.getValues()) {
                byte[] derBytes = Base64.decode((String)((String)value));
                BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(derBytes));
                try {
                    X509Certificate x509 = (X509Certificate)this.cf_.generateCertificate(bis);
                    certChain.add(x509);
                }
                catch (CertificateException e) {
                    String error = "Fails to decode X.509 certificate: " + e.getMessage();
                    this.log.error(error);
                    throw new PIPProcessingException(error, (Exception)e);
                }
            }
        }
        if (certChain.isEmpty()) {
            this.log.debug("No attribute: {} datatype: {} found in Subject", (Object)this.getCertificateAttributeId(), (Object)this.getCertificateAttributeDatatype());
            return null;
        }
        boolean proxyPresent = false;
        for (X509Certificate cert : certChain) {
            if (cert.getVersion() < 3) {
                this.log.warn("Subject certificate {} is not a version 3, or greater, certificate, certificate chain ignored", (Object)cert.getSubjectX500Principal().getName("RFC2253"));
                return null;
            }
            if (!this.isProxyCertificateRequired() || !ProxyUtils.isProxy((X509Certificate)cert)) continue;
            proxyPresent = true;
        }
        if (this.isProxyCertificateRequired() && !proxyPresent) {
            this.log.warn("Proxy is required, but none found");
            return null;
        }
        return certChain.toArray(new X509Certificate[certChain.size()]);
    }

    private static boolean isNullorNULL(String str) {
        if (str == null) {
            return true;
        }
        return NULL_STRING.equalsIgnoreCase(str);
    }

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

