/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import java.util.ArrayList;
import java.util.Arrays;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.config.AbstractConfigurationBuilder;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.IniSectionConfigurationParser;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pep.pip.PolicyInformationPoint;
import org.glite.authz.pep.pip.provider.AttributeWhitelistPIP;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class AttributeWhitelistPIPIniConfigurationParser
implements IniSectionConfigurationParser<PolicyInformationPoint> {
    public static final String ACT_ATTRIBS_PROP = "acceptedActionAttributes";
    public static final String ENV_ATTRIBS_PROP = "acceptedEnvironmentAttributes";
    public static final String RES_ATTRIBS_PROP = "acceptedResourceAttributes";
    public static final String SUB_ATTRIBS_PROP = "acceptedSubjectAttributes";
    private final Logger log = LoggerFactory.getLogger(AttributeWhitelistPIPIniConfigurationParser.class);

    public PolicyInformationPoint parse(Profile.Section iniConfig, AbstractConfigurationBuilder<?> configBuilder) throws ConfigurationException {
        String pipId = iniConfig.getName();
        Object[] actionAttributeIds = this.parseAcceptedAttributeIds((String)iniConfig.get((Object)ACT_ATTRIBS_PROP));
        if (actionAttributeIds != null && actionAttributeIds.length > 0) {
            this.log.info("{}: white listed action attributes: {}", (Object)pipId, (Object)Arrays.toString(actionAttributeIds));
        } else {
            this.log.info("{}: white listed action attributes: all", (Object)pipId);
        }
        Object[] environmentAttributeIds = this.parseAcceptedAttributeIds((String)iniConfig.get((Object)ENV_ATTRIBS_PROP));
        if (environmentAttributeIds != null && environmentAttributeIds.length > 0) {
            this.log.info("{}: white listed environment attributes: ", (Object)pipId, (Object)Arrays.toString(environmentAttributeIds));
        } else {
            this.log.info("{}: white listed environment attributes: all", (Object)pipId);
        }
        Object[] resourceAttributeIds = this.parseAcceptedAttributeIds((String)iniConfig.get((Object)RES_ATTRIBS_PROP));
        if (resourceAttributeIds != null && resourceAttributeIds.length > 0) {
            this.log.info("{}: white listed resource attributes: ", (Object)pipId, (Object)Arrays.toString(resourceAttributeIds));
        } else {
            this.log.info("{}: white listed resource attributes: all", (Object)pipId);
        }
        Object[] subjectAttributeIds = this.parseAcceptedAttributeIds((String)iniConfig.get((Object)SUB_ATTRIBS_PROP));
        if (subjectAttributeIds != null && subjectAttributeIds.length > 0) {
            this.log.info("{}: white listed subject attributes: ", (Object)pipId, (Object)Arrays.toString(subjectAttributeIds));
        } else {
            this.log.info("{}: white listed subject attributes: all", (Object)pipId);
        }
        return new AttributeWhitelistPIP(pipId, (String[])actionAttributeIds, (String[])environmentAttributeIds, (String[])resourceAttributeIds, (String[])subjectAttributeIds);
    }

    protected String[] parseAcceptedAttributeIds(String ids) {
        if (ids == null) {
            return null;
        }
        ArrayList<String> acceptedIds = new ArrayList<String>();
        for (String id : ids.split(" ")) {
            String trimmedId = Strings.safeTrimOrNullString((String)id);
            if (trimmedId == null) continue;
            acceptedIds.add(trimmedId);
        }
        return acceptedIds.toArray(new String[acceptedIds.size()]);
    }
}

