/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Resource;
import org.glite.authz.common.model.Subject;
import org.glite.authz.pep.pip.PIPProcessingException;
import org.glite.authz.pep.pip.provider.AbstractPolicyInformationPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class AttributeWhitelistPIP
extends AbstractPolicyInformationPoint {
    private Logger log = LoggerFactory.getLogger(AttributeWhitelistPIP.class);
    private Set<String> actionAttributes;
    private Set<String> environmentAttributes;
    private Set<String> resourceAttributes;
    private Set<String> subjectAttributes;

    public AttributeWhitelistPIP(String pipId, String[] acceptedActionAttributeIds, String[] acceptedEnvironmentAttributeIds, String[] acceptedResourceAttributeIds, String[] acceptedSubjectAttributeIds) {
        super(pipId);
        this.actionAttributes = acceptedActionAttributeIds == null ? null : (acceptedActionAttributeIds.length == 0 ? Collections.emptySet() : new HashSet<String>(Arrays.asList(acceptedActionAttributeIds)));
        this.environmentAttributes = acceptedEnvironmentAttributeIds == null ? null : (acceptedEnvironmentAttributeIds.length == 0 ? Collections.emptySet() : new HashSet<String>(Arrays.asList(acceptedEnvironmentAttributeIds)));
        this.resourceAttributes = acceptedResourceAttributeIds == null ? null : (acceptedResourceAttributeIds.length == 0 ? Collections.emptySet() : new HashSet<String>(Arrays.asList(acceptedResourceAttributeIds)));
        this.subjectAttributes = acceptedSubjectAttributeIds == null ? null : (acceptedSubjectAttributeIds.length == 0 ? Collections.emptySet() : new HashSet<String>(Arrays.asList(acceptedSubjectAttributeIds)));
    }

    public boolean populateRequest(Request request) throws PIPProcessingException, IllegalStateException {
        Set subjects;
        boolean applied = false;
        Set resources = request.getResources();
        if (resources != null) {
            for (Resource resource : resources) {
                if (resource == null) continue;
                applied = true;
                this.log.debug("Filtering resource attributes");
                this.filterAttributes(resource.getAttributes(), this.resourceAttributes);
            }
        }
        if ((subjects = request.getSubjects()) != null) {
            for (Subject subject : subjects) {
                if (subject == null) continue;
                applied = true;
                this.log.debug("Filtering subject attributes");
                this.filterAttributes(subject.getAttributes(), this.subjectAttributes);
            }
        }
        if (request.getAction() != null) {
            applied = true;
            this.log.debug("Filtering action attributes");
            this.filterAttributes(request.getAction().getAttributes(), this.actionAttributes);
        }
        if (request.getEnvironment() != null) {
            applied = true;
            this.log.debug("Filtering environment attributes");
            this.filterAttributes(request.getEnvironment().getAttributes(), this.environmentAttributes);
        }
        return applied;
    }

    protected void filterAttributes(Set<Attribute> attributes, Set<String> acceptedIds) {
        if (attributes == null || attributes.isEmpty() || acceptedIds == null) {
            return;
        }
        if (acceptedIds.isEmpty()) {
            this.log.debug("No attributes allowed, removing all attributes from the request");
            attributes.clear();
        }
        Iterator<Attribute> attribtueItr = attributes.iterator();
        ArrayList<Attribute> removedAttributes = new ArrayList<Attribute>();
        while (attribtueItr.hasNext()) {
            Attribute attribute = attribtueItr.next();
            if (acceptedIds.contains(attribute.getId())) continue;
            this.log.debug("Attribute {} not allowed, removing it from the request.", (Object)attribute.getId());
            removedAttributes.add(attribute);
        }
        attributes.removeAll(removedAttributes);
    }
}

