/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import java.util.Arrays;
import java.util.List;
import org.glite.authz.common.config.AbstractConfigurationBuilder;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.IniConfigUtil;
import org.glite.authz.common.config.IniSectionConfigurationParser;
import org.glite.authz.common.util.Files;
import org.glite.authz.pep.pip.PolicyInformationPoint;
import org.ini4j.Profile;
import org.italiangrid.voms.VOMSValidators;
import org.italiangrid.voms.ac.VOMSACValidator;
import org.italiangrid.voms.store.VOMSTrustStore;
import org.italiangrid.voms.store.VOMSTrustStoreStatusListener;
import org.italiangrid.voms.store.VOMSTrustStores;
import org.italiangrid.voms.util.NullListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractX509PIPIniConfigurationParser
implements IniSectionConfigurationParser<PolicyInformationPoint> {
    public static final String REQUIRE_CERTIFICATE_PROP = "requireCertificate";
    public static final boolean DEFAULT_REQUIRE_CERTIFICATE = true;
    public static final String REQUIRE_PROXY_PROP = "requireProxy";
    public static final boolean DEFAULT_REQUIRE_PROXY = false;
    public static final String PERFORM_PKIX_VALIDATION_PROP = "performPKIXValidation";
    public static final String VOMS_INFO_DIR_PROP = "vomsInfoDir";
    public static final String VOMS_INFO_REFRESH_PROP = "vomsInfoRefresh";
    public static final int DEFAULT_VOMS_INFO_REFRESH = 60;
    public static final boolean DEFAULT_PERFORM_PKIX_VALIDATION = true;
    private Logger log = LoggerFactory.getLogger(AbstractX509PIPIniConfigurationParser.class);

    public PolicyInformationPoint parse(Profile.Section iniConfig, AbstractConfigurationBuilder<?> configurationBuilder) throws ConfigurationException {
        String pipId = iniConfig.getName();
        boolean requireProxy = IniConfigUtil.getBoolean((Profile.Section)iniConfig, (String)REQUIRE_PROXY_PROP, (boolean)false);
        this.log.info("{}: subject proxy certificate required: {}", (Object)pipId, (Object)requireProxy);
        VOMSACValidator vomsValidator = null;
        String vomsInfoDir = IniConfigUtil.getString((Profile.Section)iniConfig, (String)VOMS_INFO_DIR_PROP, null);
        if (vomsInfoDir != null) {
            this.log.info("{}: VOMS info directory: {}", (Object)pipId, (Object)vomsInfoDir);
            int vomsInfoRefresh = IniConfigUtil.getInt((Profile.Section)iniConfig, (String)VOMS_INFO_REFRESH_PROP, (int)60, (int)1, (int)Integer.MAX_VALUE);
            vomsInfoRefresh = vomsInfoRefresh * 60 * 1000;
            this.log.info("{}: VOMS info refresh interval: {}ms", (Object)pipId, (Object)vomsInfoRefresh);
            try {
                Files.getFile((String)vomsInfoDir, (boolean)false, (boolean)true, (boolean)true, (boolean)false);
                List<String> vomsInfoDirs = Arrays.asList(vomsInfoDir);
                VOMSTrustStore vomsTrustStore = VOMSTrustStores.newTrustStore(vomsInfoDirs, (long)vomsInfoRefresh, (VOMSTrustStoreStatusListener)NullListener.INSTANCE);
                X509CertChainValidatorExt certChainValidator = configurationBuilder.getCertChainValidator();
                vomsValidator = VOMSValidators.newValidator((VOMSTrustStore)vomsTrustStore, (X509CertChainValidatorExt)certChainValidator);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to read VOMS AC validation information", e);
            }
        }
        boolean requireCertificate = IniConfigUtil.getBoolean((Profile.Section)iniConfig, (String)REQUIRE_CERTIFICATE_PROP, (boolean)this.getRequireCertificateDefault());
        this.log.info("{}: require a certificate chains: {}", (Object)pipId, (Object)requireCertificate);
        boolean performPKIXValidation = IniConfigUtil.getBoolean((Profile.Section)iniConfig, (String)PERFORM_PKIX_VALIDATION_PROP, (boolean)true);
        this.log.info("{}: perform PKIX validation on cert chains: {}", (Object)pipId, (Object)performPKIXValidation);
        PolicyInformationPoint pip = this.buildInformationPoint(iniConfig, requireProxy, (X509CertChainValidator)configurationBuilder.getCertChainValidator(), vomsValidator, performPKIXValidation, requireCertificate);
        return pip;
    }

    protected boolean getRequireCertificateDefault() {
        return true;
    }

    protected abstract PolicyInformationPoint buildInformationPoint(Profile.Section var1, boolean var2, X509CertChainValidator var3, VOMSACValidator var4, boolean var5, boolean var6) throws ConfigurationException;
}

