/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip.provider;

import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.ValidationResult;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Subject;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pep.pip.PIPException;
import org.glite.authz.pep.pip.PIPProcessingException;
import org.glite.authz.pep.pip.provider.AbstractPolicyInformationPoint;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.ac.VOMSACValidator;
import org.italiangrid.voms.ac.VOMSValidationResult;
import org.italiangrid.voms.error.VOMSValidationErrorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractX509PIP
extends AbstractPolicyInformationPoint {
    private Logger log = LoggerFactory.getLogger(AbstractX509PIP.class);
    private boolean requireCertificate = true;
    private boolean requireProxyCertificate;
    private boolean performPKIXValidation;
    private boolean vomsSupportEnabled;
    private X509CertChainValidator certChainValidator;
    private VOMSACValidator vomsACValidator;

    public AbstractX509PIP(String pipID, boolean requireProxy, X509CertChainValidator x509Validator, VOMSACValidator vomsACValidator) throws ConfigurationException {
        super(pipID);
        this.requireProxyCertificate = requireProxy;
        if (x509Validator == null) {
            throw new ConfigurationException("Policy information point trust material may not be null");
        }
        this.vomsSupportEnabled = vomsACValidator != null;
        this.certChainValidator = x509Validator;
        this.vomsACValidator = vomsACValidator;
    }

    public boolean isVOMSSupportEnabled() {
        return this.vomsSupportEnabled;
    }

    public boolean isPKIXValidationEnabled() {
        return this.performPKIXValidation;
    }

    public boolean isProxyCertificateRequired() {
        return this.requireProxyCertificate;
    }

    public void performPKIXValidation(boolean perform) {
        this.performPKIXValidation = perform;
    }

    public X509CertChainValidator getX509CertChainValidator() {
        return this.certChainValidator;
    }

    protected VOMSACValidator getVOMSACValidator() {
        return this.vomsACValidator;
    }

    @Override
    public void stop() throws PIPException {
        super.stop();
        if (this.vomsACValidator != null) {
            this.log.debug("Shutdown VOMS AC validator...");
            this.vomsACValidator.shutdown();
            this.vomsACValidator = null;
        }
    }

    public boolean populateRequest(Request request) throws PIPProcessingException {
        if (!this.appliesToRequest(request)) {
            return false;
        }
        for (Subject subject : request.getSubjects()) {
            String certSubject;
            int i;
            this.log.debug("Extracting cert chain from Subject...");
            X509Certificate[] certChain = this.extractCertificateChain(subject);
            if (certChain == null) continue;
            certChain = this.sortCertificateChain(certChain);
            certChain = this.completeCertificateChain(certChain);
            if (this.log.isDebugEnabled()) {
                i = 0;
                this.log.debug("before caNl validation:");
                for (X509Certificate cert : certChain) {
                    certSubject = cert.getSubjectX500Principal().getName("RFC2253");
                    this.log.debug("certChain[{}]: {}", (Object)i++, (Object)certSubject);
                }
            }
            if (this.isPKIXValidationEnabled()) {
                this.log.debug("Validating cert chain...");
                ValidationResult result = this.certChainValidator.validate(certChain);
                if (!result.isValid()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("PKIX validation failed: ");
                    for (ValidationError validationError : result.getErrors()) {
                        sb.append(validationError.getMessage());
                        sb.append(",");
                    }
                    String errorMsg = sb.toString();
                    this.log.error(errorMsg);
                    throw new PIPProcessingException(errorMsg);
                }
                List validChain = result.getValidChain();
                certChain = validChain.toArray(new X509Certificate[validChain.size()]);
            }
            if (this.log.isDebugEnabled()) {
                i = 0;
                this.log.debug("after caNl validation:");
                for (X509Certificate cert : certChain) {
                    certSubject = cert.getSubjectX500Principal().getName("RFC2253");
                    this.log.debug("certChain[{}]: {}", (Object)i++, (Object)certSubject);
                }
            }
            X509Certificate userCert = ProxyUtils.getEndUserCertificate((X509Certificate[])certChain);
            this.log.debug("Extracting subject attributes from certificate with subject: {}", (Object)userCert.getSubjectX500Principal());
            Collection<Attribute> certAttributes = this.processCertChain(userCert, certChain);
            if (certAttributes == null) continue;
            this.log.debug("Extracted subject attributes {} from certificate with subject {}", certAttributes, (Object)userCert.getSubjectX500Principal());
            this.updateSubjectCertificateAttributes(subject, certAttributes);
            return true;
        }
        if (this.requireCertificate) {
            String errMsg = "Subject did not contain the required certificate chain in attribute: " + this.getCertificateAttributeId() + " datatype: " + this.getCertificateAttributeDatatype();
            this.log.error(errMsg);
            throw new PIPProcessingException(errMsg);
        }
        this.log.debug("No certificate chain found, but requireCertificate=" + this.requireCertificate);
        return true;
    }

    protected void setRequireCertificate(boolean required) {
        this.requireCertificate = required;
    }

    private void updateSubjectCertificateAttributes(Subject subject, Collection<Attribute> certAttributes) {
        for (Attribute certAttribute : certAttributes) {
            boolean alreadyExists = false;
            String certAttributeId = certAttribute.getId();
            String certAttributeDataType = certAttribute.getDataType();
            for (Attribute subjectAttribute : subject.getAttributes()) {
                if (!subjectAttribute.getId().equals(certAttributeId) || !subjectAttribute.getDataType().equals(certAttributeDataType)) continue;
                alreadyExists = true;
                this.log.debug("Subject {} already contains values, replace them with {}", (Object)subjectAttribute, (Object)certAttribute);
                subjectAttribute.getValues().clear();
                subjectAttribute.getValues().addAll(certAttribute.getValues());
            }
            if (alreadyExists) continue;
            this.log.debug("Add {} to Subject", (Object)certAttribute);
            subject.getAttributes().add(certAttribute);
        }
    }

    protected abstract boolean appliesToRequest(Request var1);

    protected X509Certificate[] extractCertificateChain(Subject subject) throws PIPProcessingException {
        String pemCertChain = null;
        for (Attribute attribute : subject.getAttributes()) {
            if (!Strings.safeEquals((Object)attribute.getId(), (Object)this.getCertificateAttributeId()) || !Strings.safeEquals((Object)attribute.getDataType(), (Object)this.getCertificateAttributeDatatype())) continue;
            if (pemCertChain != null || attribute.getValues().size() < 1) {
                String errorMsg = "Subject contains more than one X509 certificate chain.";
                this.log.error(errorMsg);
                throw new PIPProcessingException(errorMsg);
            }
            if (attribute.getValues().size() != 1) continue;
            pemCertChain = Strings.safeTrimOrNullString((String)((String)attribute.getValues().iterator().next()));
        }
        if (pemCertChain == null) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(pemCertChain.getBytes());
        X509Certificate[] certChain = null;
        try {
            certChain = CertificateUtils.loadCertificateChain((InputStream)is, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
        }
        catch (IOException e) {
            String error = "Failed to load certificate chain from Subject: " + e.getMessage();
            this.log.error(error);
            throw new PIPProcessingException(error, (Exception)e);
        }
        boolean proxyPresent = false;
        for (X509Certificate cert : certChain) {
            if (cert.getVersion() < 3) {
                this.log.warn("Subject certificate {} is not a version 3, or greater, certificate, certificate chain ignored", (Object)cert.getSubjectX500Principal().getName("RFC2253"));
                return null;
            }
            if (!this.isProxyCertificateRequired() || !ProxyUtils.isProxy((X509Certificate)cert)) continue;
            proxyPresent = true;
        }
        if (this.isProxyCertificateRequired() && !proxyPresent) {
            this.log.warn("Proxy is required, but none found");
            return null;
        }
        return certChain;
    }

    protected abstract String getCertificateAttributeId();

    protected abstract String getCertificateAttributeDatatype();

    protected abstract Collection<Attribute> processCertChain(X509Certificate var1, X509Certificate[] var2) throws PIPProcessingException;

    protected VOMSAttribute extractVOMSAttributeCertificate(X509Certificate[] certChain) throws PIPProcessingException {
        List results = this.vomsACValidator.validateWithResult(certChain);
        if (results.isEmpty()) {
            this.log.warn("No VOMS attributes found in cert chain: {}", (Object)certChain[0].getSubjectX500Principal().getName("RFC2253"));
            return null;
        }
        for (VOMSValidationResult result : results) {
            if (result.isValid()) {
                return result.getAttributes();
            }
            List errorMessages = result.getValidationErrors();
            Iterator i$ = errorMessages.iterator();
            if (!i$.hasNext()) continue;
            VOMSValidationErrorMessage errorMessage = (VOMSValidationErrorMessage)i$.next();
            this.log.error(errorMessage.getMessage());
            throw new PIPProcessingException(errorMessage.getMessage());
        }
        this.log.error("Unable to extract VOMS attributes (this error should never occur)");
        return null;
    }

    protected X509Certificate[] sortCertificateChain(X509Certificate[] certChain) throws PIPProcessingException {
        X509Certificate child;
        X509Certificate parent;
        if (certChain.length == 0) {
            return new X509Certificate[0];
        }
        this.log.trace("sorting certificate chain...");
        List<X509Certificate> certificates = Arrays.asList(certChain);
        HashMap<X500Principal, X509Certificate> certsMapBySubject = new HashMap<X500Principal, X509Certificate>();
        HashMap<X500Principal, X509Certificate> certsMapByIssuer = new HashMap<X500Principal, X509Certificate>();
        for (X509Certificate c : certificates) {
            certsMapBySubject.put(c.getSubjectX500Principal(), c);
            if (c.getIssuerX500Principal().equals(c.getSubjectX500Principal())) continue;
            certsMapByIssuer.put(c.getIssuerX500Principal(), c);
        }
        LinkedList<X509Certificate> certsList = new LinkedList<X509Certificate>();
        X509Certificate current = (X509Certificate)certsMapBySubject.remove(certificates.get(0).getSubjectX500Principal());
        if (!current.getIssuerX500Principal().equals(current.getSubjectX500Principal())) {
            certsMapByIssuer.remove(current.getIssuerX500Principal());
        }
        certsList.add(current);
        while ((parent = (X509Certificate)certsMapBySubject.remove(current.getIssuerX500Principal())) != null) {
            certsMapByIssuer.remove(parent.getIssuerX500Principal());
            certsList.add(parent);
            current = parent;
        }
        current = (X509Certificate)certsList.get(0);
        while ((child = (X509Certificate)certsMapByIssuer.remove(current.getSubjectX500Principal())) != null) {
            certsList.add(0, child);
            current = child;
        }
        if (certsMapByIssuer.size() > 0) {
            throw new PIPProcessingException("The certificate chain can not be sorted, it is inconsistent.");
        }
        return certsList.toArray(new X509Certificate[certsList.size()]);
    }

    protected X509Certificate[] completeCertificateChain(X509Certificate[] certChain) {
        this.log.debug("implemented in caNl validator...");
        return certChain;
    }
}

