/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.pip;

import java.util.List;
import org.glite.authz.common.http.ShutdownTask;
import org.glite.authz.pep.pip.PIPException;
import org.glite.authz.pep.pip.PolicyInformationPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyInformationPointsShutdownTask
implements ShutdownTask {
    private Logger log = LoggerFactory.getLogger(PolicyInformationPointsShutdownTask.class);
    List<PolicyInformationPoint> pips_;

    public PolicyInformationPointsShutdownTask(List<PolicyInformationPoint> pips) {
        this.pips_ = pips;
    }

    public void run() {
        this.log.info("Stopping all PIPs");
        if (this.pips_ != null) {
            for (PolicyInformationPoint pip : this.pips_) {
                this.log.debug("Stopping PIP {}", (Object)pip.getId());
                try {
                    pip.stop();
                }
                catch (PIPException e) {
                    this.log.error("Can not stop " + pip.getId(), (Throwable)e);
                }
            }
        }
    }
}

