/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.dfpmap;

import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import org.glite.authz.pep.obligation.dfpmap.DFPMMatchStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509MatchStrategy
implements DFPMMatchStrategy<X500Principal> {
    private final Logger log = LoggerFactory.getLogger(X509MatchStrategy.class);

    @Override
    public boolean isMatch(String dfpmKey, X500Principal candidate) {
        X500Principal target = this.keyToDN(dfpmKey);
        if (target == null) {
            return false;
        }
        boolean matches = target.equals(candidate);
        if (this.log.isTraceEnabled()) {
            this.log.trace("'{}' matches '{}' ? {}", new Object[]{candidate, target, matches});
        }
        return matches;
    }

    private X500Principal keyToDN(String key) {
        String rfc2253DN;
        if (key.startsWith("/")) {
            ArrayList<String> rdns = new ArrayList<String>();
            StringBuilder rdnBuilder = new StringBuilder();
            for (int i = 1; i < key.length(); ++i) {
                char character = key.charAt(i);
                if (character != '/') {
                    rdnBuilder.append(character);
                    continue;
                }
                if (key.charAt(i - 1) == '\\') {
                    rdnBuilder.deleteCharAt(rdnBuilder.length() - 1);
                    rdnBuilder.append("/");
                    continue;
                }
                rdns.add(rdnBuilder.toString());
                rdnBuilder = new StringBuilder();
            }
            rdns.add(rdnBuilder.toString());
            StringBuilder dn = new StringBuilder();
            for (int i = rdns.size() - 1; i >= 0; --i) {
                dn.append((String)rdns.get(i));
                if (i <= 0) continue;
                dn.append(",");
            }
            rfc2253DN = dn.toString();
        } else {
            rfc2253DN = key;
        }
        try {
            return new X500Principal(rfc2253DN);
        }
        catch (Exception e) {
            this.log.debug("Failed to convert '" + key + "' to X500Principal(" + rfc2253DN + ")", (Throwable)e);
            return null;
        }
    }
}

