/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.dfpmap;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.util.Files;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pep.obligation.dfpmap.DFPM;
import org.glite.authz.pep.obligation.dfpmap.DFPMFileParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatingDFPM
implements DFPM {
    private final Logger log = LoggerFactory.getLogger(UpdatingDFPM.class);
    private DFPM delegate;
    private Timer taskTimer;
    private final DFPMFactory dfpmFactory;
    private final String mappingFilePath;

    public UpdatingDFPM(DFPMFactory factory, String mappingFile, long refreshPeriod) {
        if (factory == null) {
            throw new IllegalArgumentException("mapping factory may not be null");
        }
        this.dfpmFactory = factory;
        this.mappingFilePath = Strings.safeTrimOrNullString((String)mappingFile);
        if (this.mappingFilePath == null) {
            throw new IllegalArgumentException("mapping file may not be null");
        }
        try {
            Files.getReadableFile((String)this.mappingFilePath);
        }
        catch (IOException e) {
            this.log.error("Unable to read map file " + this.mappingFilePath, (Throwable)e);
            throw new IllegalArgumentException("Unable to read map file " + this.mappingFilePath, e);
        }
        if (refreshPeriod < 1L) {
            throw new IllegalArgumentException("Refresh period must be 1 or greater");
        }
        UpdateDFPMTask updateTask = new UpdateDFPMTask();
        updateTask.run();
        this.taskTimer = new Timer(true);
        this.taskTimer.scheduleAtFixedRate((TimerTask)updateTask, refreshPeriod, refreshPeriod);
    }

    @Override
    public boolean isDNMapEntry(String key) {
        return this.delegate.isDNMapEntry(key);
    }

    @Override
    public boolean isFQANMapEntry(String key) {
        return this.delegate.isFQANMapEntry(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public List<String> get(Object key) {
        return (List)this.delegate.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public List<String> put(String key, List<String> value) {
        return this.delegate.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map) {
        this.delegate.putAll(map);
    }

    @Override
    public List<String> remove(Object key) {
        return (List)this.delegate.remove(key);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Collection<List<String>> values() {
        return this.delegate.values();
    }

    public static interface DFPMFactory {
        public DFPM newInstance();
    }

    private class UpdateDFPMTask
    extends TimerTask {
        private long mappingFileLastModified;

        private UpdateDFPMTask() {
        }

        public void run() {
            try {
                UpdatingDFPM.this.log.trace("Refreshing mapping file: {}", (Object)UpdatingDFPM.this.mappingFilePath);
                File mappingFile = Files.getReadableFile((String)UpdatingDFPM.this.mappingFilePath);
                if (mappingFile.lastModified() <= this.mappingFileLastModified) {
                    UpdatingDFPM.this.log.trace("Mapping file has not changed since last refresh, nothing need to be done.");
                    return;
                }
                DFPM dfpm = UpdatingDFPM.this.dfpmFactory.newInstance();
                DFPMFileParser mappingFileParser = new DFPMFileParser();
                mappingFileParser.parse(dfpm, new FileReader(mappingFile));
                this.mappingFileLastModified = mappingFile.lastModified();
                UpdatingDFPM.this.delegate = dfpm;
            }
            catch (IOException e) {
                UpdatingDFPM.this.log.error("Unable to read mapping file " + UpdatingDFPM.this.mappingFilePath + " due to the following error.  DN/FQAN mapping will not be updated.", (Throwable)e);
            }
            catch (ConfigurationException e) {
                UpdatingDFPM.this.log.error("Unable to parse mapping file " + UpdatingDFPM.this.mappingFilePath + ".  DN/FQAN mapping will not be updated.", (Throwable)e);
            }
        }
    }
}

