/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.dfpmap;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXFactory;
import org.jruby.ext.posix.POSIXHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PosixUtil {
    private static POSIX posix = POSIXFactory.getPOSIX((POSIXHandler)new BasicPOSIXHandler(), (boolean)true);
    private static Logger log = LoggerFactory.getLogger(PosixUtil.class);

    public static FileStat getFileStat(String file) {
        return posix.stat(file);
    }

    public static void createLink(String currenPath, String newPath, boolean symbolic) {
        if (symbolic) {
            posix.symlink(currenPath, newPath);
        } else {
            posix.link(currenPath, newPath);
        }
    }

    public static void createSymlink(String sourcePath, String targetPath) {
        PosixUtil.createLink(sourcePath, targetPath, true);
    }

    public static void createHardlink(String sourcePath, String targetPath) {
        PosixUtil.createLink(sourcePath, targetPath, false);
    }

    public static void touchFile(File file) {
        try {
            boolean success;
            log.debug("touch {}", (Object)file.getAbsolutePath());
            if (!file.exists()) {
                FileOutputStream out = new FileOutputStream(file);
                ((OutputStream)out).close();
            }
            if (!(success = file.setLastModified(System.currentTimeMillis()))) {
                throw new IOException("Unable to set the last modification time for " + file);
            }
        }
        catch (IOException e) {
            log.warn("touch {} failed: {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
        }
    }

    public static class BasicPOSIXHandler
    implements POSIXHandler {
        public void error(POSIX.ERRORS error, String extraData) {
            log.error("Error performing POSIX operation. Error: " + error.toString() + ", additional data: " + extraData);
        }

        public void unimplementedError(String methodName) {
            log.error("Error performing POSIX operation.  Operation " + methodName + " is not supported");
        }

        public void warn(POSIXHandler.WARNING_ID id, String message, Object ... data) {
            log.warn(message);
        }

        public boolean isVerbose() {
            return false;
        }

        public File getCurrentWorkingDirectory() {
            return new File("/tmp");
        }

        public String[] getEnv() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public InputStream getInputStream() {
            return System.in;
        }

        public PrintStream getOutputStream() {
            return System.out;
        }

        public int getPID() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public PrintStream getErrorStream() {
            return System.err;
        }
    }
}

