/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.dfpmap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glite.authz.common.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PosixAccount
implements Serializable {
    private static final long serialVersionUID = -6232923043396000457L;
    private String loginName;
    private String primaryGroup;
    private List<String> secondaryGroups;
    private String stringRepresentation;

    public PosixAccount(String login, String newPrimaryGroup, List<String> newSecondaryGroups) {
        this.loginName = Strings.safeTrimOrNullString((String)login);
        if (this.loginName == null) {
            throw new IllegalArgumentException("Login name may not be empty or null");
        }
        this.primaryGroup = newPrimaryGroup;
        this.secondaryGroups = newSecondaryGroups == null || newSecondaryGroups.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(newSecondaryGroups));
        this.computeString();
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getPrimaryGroup() {
        return this.primaryGroup;
    }

    public List<String> getSecondaryGroups() {
        return this.secondaryGroups;
    }

    public int hashCode() {
        int hash = 13;
        hash = 31 * hash + this.loginName.hashCode();
        hash = 31 * hash + this.primaryGroup.hashCode();
        hash = 31 * hash + ((Object)this.secondaryGroups).hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof PosixAccount) {
            PosixAccount other = (PosixAccount)obj;
            return this.loginName.equals(other.loginName) && this.primaryGroup.equals(other.primaryGroup) && ((Object)this.secondaryGroups).equals(other.secondaryGroups);
        }
        return false;
    }

    public String toString() {
        return this.stringRepresentation;
    }

    private void computeString() {
        StringBuilder string = new StringBuilder("PosixAccount");
        string.append("{");
        string.append("user=").append(this.loginName);
        if (this.primaryGroup != null) {
            string.append(" group=").append(this.primaryGroup);
        }
        if (this.secondaryGroups != null && !this.secondaryGroups.isEmpty()) {
            string.append(" groups=");
            boolean first = true;
            for (String group : this.secondaryGroups) {
                if (!first) {
                    string.append(",");
                }
                string.append(group);
                first = false;
            }
        }
        string.append("}");
        this.stringRepresentation = string.toString();
    }
}

