/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.dfpmap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.glite.authz.pep.obligation.ObligationProcessingException;
import org.glite.authz.pep.obligation.dfpmap.PoolAccountManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryBackedPoolAcountManager
implements PoolAccountManager {
    private final Logger log = LoggerFactory.getLogger(MemoryBackedPoolAcountManager.class);
    private HashMap<String, List<String>> managedAccounts = new HashMap();
    private HashMap<String, String> currentAccountMappings = new HashMap();

    public MemoryBackedPoolAcountManager(List<String> poolAccounts) {
        if (poolAccounts != null) {
            Pattern accountPrefixPat = Pattern.compile("^(\\p{Alpha}*)\\p{Digit}*$");
            for (String account : poolAccounts) {
                Matcher prefixMatcher = accountPrefixPat.matcher(account);
                if (prefixMatcher.find()) {
                    String prefix = prefixMatcher.group(1);
                    if (prefix != null) {
                        this.addManagedPoolAccount(prefix, account);
                        continue;
                    }
                    this.log.warn("{} did not contain a valid pool account name prefix, ignoring it");
                    continue;
                }
                this.log.warn("{} is not a valid pool account name, ignoring it");
            }
        }
    }

    @Override
    public List<String> getPoolAccountNamePrefixes() {
        return new ArrayList<String>(this.managedAccounts.keySet());
    }

    @Override
    public List<String> getPoolAccountNames() {
        ArrayList<String> allManagedAccounts = new ArrayList<String>();
        for (List<String> accountSet : this.managedAccounts.values()) {
            allManagedAccounts.addAll(accountSet);
        }
        return allManagedAccounts;
    }

    @Override
    public List<String> getPoolAccountNames(String prefix) {
        return this.managedAccounts.get(prefix);
    }

    @Override
    public boolean isPoolAccountPrefix(String accountIndicator) {
        return accountIndicator.startsWith(".");
    }

    @Override
    public String getPoolAccountPrefix(String accountIndicator) {
        if (this.isPoolAccountPrefix(accountIndicator)) {
            return accountIndicator.substring(1);
        }
        return null;
    }

    @Override
    public synchronized String mapToAccount(String accountNamePrefix, X500Principal subjectDN, String primaryGroup, List<String> secondaryGroups) throws ObligationProcessingException {
        if (accountNamePrefix.startsWith(".")) {
            accountNamePrefix = accountNamePrefix.substring(1);
        }
        this.log.debug("Mapping subject {} with primary group {} and secondary groups {} to a pool account with prefix {}", new Object[]{subjectDN.getName(), primaryGroup, secondaryGroups, accountNamePrefix});
        String accountMappingKey = this.createAccountMappingKey(subjectDN, primaryGroup, secondaryGroups);
        String loginName = this.currentAccountMappings.get(accountMappingKey);
        if (loginName != null) {
            this.log.debug("Subject {} has an existing account mapping to account {}", (Object)subjectDN.getName(), (Object)loginName);
            if (!loginName.startsWith(accountNamePrefix)) {
                this.log.error("Subject " + subjectDN.getName() + " has an existing mapping to account " + loginName + " but this account name does not start with the pool account name prefix, " + accountNamePrefix + ", to which they were mapped.");
                throw new ObligationProcessingException("Error with existing pool account mapping for this subject");
            }
            return loginName;
        }
        List<String> managedAccounts = this.getPoolAccountNames(accountNamePrefix);
        if (managedAccounts == null) {
            return null;
        }
        this.log.debug("Subject {} does not have an existing pool account mapping, attempting to create a new one", (Object)subjectDN.getName());
        for (String account : managedAccounts) {
            if (this.currentAccountMappings.values().contains(account)) continue;
            this.log.debug("Subject {} given a new pool account mapping to account {}", (Object)subjectDN.getName(), (Object)account);
            loginName = account;
            this.currentAccountMappings.put(accountMappingKey, account);
            return loginName;
        }
        this.log.warn("No pool account, with prefix {}, available to which {} could be mapped", (Object)accountNamePrefix, (Object)subjectDN.getName());
        return null;
    }

    private String createAccountMappingKey(X500Principal subjectDN, String primaryGroup, List<String> secondaryGroups) {
        StringBuilder builder = new StringBuilder(subjectDN.getName("CANONICAL"));
        if (primaryGroup != null) {
            builder.append(":").append(primaryGroup);
            if (secondaryGroups != null) {
                for (String name : secondaryGroups) {
                    builder.append(":").append(name);
                }
            }
        }
        return builder.toString();
    }

    private void addManagedPoolAccount(String prefix, String loginName) {
        if (!loginName.startsWith(prefix)) {
            throw new IllegalArgumentException("Account name " + loginName + " does not begin with the provided pool account name prefix " + prefix);
        }
        List<String> accounts = this.managedAccounts.get(prefix);
        if (accounts == null) {
            accounts = new ArrayList<String>();
            this.managedAccounts.put(prefix, accounts);
        }
        accounts.add(loginName);
    }
}

