/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.dfpmap;

import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pep.obligation.ObligationProcessingException;
import org.glite.authz.pep.obligation.dfpmap.PoolAccountManager;
import org.glite.authz.pep.obligation.dfpmap.PosixUtil;
import org.jruby.ext.posix.FileStat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridMapDirPoolAccountManager
implements PoolAccountManager {
    private Logger log = LoggerFactory.getLogger(GridMapDirPoolAccountManager.class);
    private final File gridMapDirectory_;
    private boolean useSecondaryGroupNamesForMapping_ = true;
    private final Pattern poolAccountNamePattern_ = Pattern.compile("^([a-zA-Z][a-zA-Z0-9._-]*?)[0-9]++$");
    protected static final BitSet ALPHANUM;

    public GridMapDirPoolAccountManager(File gridMapDir, boolean useSecondaryGroupNamesForMapping) {
        if (!gridMapDir.exists()) {
            throw new IllegalArgumentException("Grid map directory " + gridMapDir.getAbsolutePath() + " does not exist");
        }
        if (!gridMapDir.canRead()) {
            throw new IllegalArgumentException("Grid map directory " + gridMapDir.getAbsolutePath() + " is not readable by this process");
        }
        if (!gridMapDir.canWrite()) {
            throw new IllegalArgumentException("Grid map directory " + gridMapDir.getAbsolutePath() + " is not writable by this process");
        }
        this.gridMapDirectory_ = gridMapDir;
        this.useSecondaryGroupNamesForMapping_ = useSecondaryGroupNamesForMapping;
    }

    @Override
    public List<String> getPoolAccountNamePrefixes() {
        File[] files;
        ArrayList<String> poolAccountNames = new ArrayList<String>();
        for (File file : files = this.gridMapDirectory_.listFiles()) {
            Matcher nameMatcher;
            if (!file.isFile() || !(nameMatcher = this.poolAccountNamePattern_.matcher(file.getName())).matches() || poolAccountNames.contains(nameMatcher.group(1))) continue;
            poolAccountNames.add(nameMatcher.group(1));
        }
        return poolAccountNames;
    }

    @Override
    public List<String> getPoolAccountNames() {
        return Arrays.asList(this.getAccountFileNames(null));
    }

    @Override
    public List<String> getPoolAccountNames(String prefix) {
        return Arrays.asList(this.getAccountFileNames(Strings.safeTrimOrNullString((String)prefix)));
    }

    @Override
    public boolean isPoolAccountPrefix(String accountIndicator) {
        return accountIndicator.startsWith(".");
    }

    @Override
    public String getPoolAccountPrefix(String accountIndicator) {
        if (this.isPoolAccountPrefix(accountIndicator)) {
            return accountIndicator.substring(1);
        }
        return null;
    }

    @Override
    public String mapToAccount(String accountNamePrefix, X500Principal subjectDN, String primaryGroup, List<String> secondaryGroups) throws ObligationProcessingException {
        String subjectIdentifier = this.buildSubjectIdentifier(subjectDN, primaryGroup, secondaryGroups);
        File subjectIdentifierFile = new File(this.buildSubjectIdentifierFilePath(subjectIdentifier));
        this.log.debug("Checking if there is an existing account mapping for subject {} with primary group {} and secondary groups {}", new Object[]{subjectDN.getName(), primaryGroup, secondaryGroups});
        String accountName = this.getAccountNameByKey(accountNamePrefix, subjectIdentifier);
        if (accountName != null) {
            PosixUtil.touchFile(subjectIdentifierFile);
            this.log.debug("An existing account mapping has mapped subject {} with primary group {} and secondary groups {} to pool account {}", new Object[]{subjectDN.getName(), primaryGroup, secondaryGroups, accountName});
            return accountName;
        }
        accountName = this.createMapping(accountNamePrefix, subjectIdentifier);
        if (accountName != null) {
            PosixUtil.touchFile(subjectIdentifierFile);
            this.log.debug("A new account mapping has mapped subject {} with primary group {} and secondary groups {} to pool account {}", new Object[]{subjectDN.getName(), primaryGroup, secondaryGroups, accountName});
        } else {
            this.log.debug("No pool account was available to which subject {} with primary group {} and secondary groups {} could be mapped", new Object[]{subjectDN.getName(), primaryGroup, secondaryGroups});
        }
        return accountName;
    }

    private String getAccountNameByKey(String accountNamePrefix, String subjectIdentifier) throws ObligationProcessingException {
        File subjectIdentifierFile = new File(this.buildSubjectIdentifierFilePath(subjectIdentifier));
        if (!subjectIdentifierFile.exists()) {
            return null;
        }
        FileStat subjectIdentifierFileStat = PosixUtil.getFileStat(subjectIdentifierFile.getAbsolutePath());
        if (subjectIdentifierFileStat.nlink() != 2) {
            this.log.error("The subject identifier file " + subjectIdentifierFile.getAbsolutePath() + " has a link count greater than 2.  This mapping is corrupted and can not be used.");
            throw new ObligationProcessingException("Unable to map subject to a POSIX account");
        }
        for (File accountFile : this.getAccountFiles(accountNamePrefix)) {
            FileStat accountFileStat = PosixUtil.getFileStat(accountFile.getAbsolutePath());
            if (accountFileStat.ino() != subjectIdentifierFileStat.ino()) continue;
            if (accountFileStat.nlink() != 2) {
                this.log.error("The pool account file " + accountFile.getAbsolutePath() + " has a link count greater than 2.  This mapping is corrupted and can not be used.");
            }
            return accountFile.getName();
        }
        return null;
    }

    protected String createMapping(String accountNamePrefix, String subjectIdentifier) {
        for (File accountFile : this.getAccountFiles(accountNamePrefix)) {
            this.log.debug("Checking if grid map account {} may be linked to subject identifier {}", (Object)accountFile.getName(), (Object)subjectIdentifier);
            String subjectIdentifierFilePath = this.buildSubjectIdentifierFilePath(subjectIdentifier);
            FileStat accountFileStat = PosixUtil.getFileStat(accountFile.getAbsolutePath());
            if (accountFileStat.nlink() == 1) {
                PosixUtil.createHardlink(accountFile.getAbsolutePath(), subjectIdentifierFilePath);
                accountFileStat = PosixUtil.getFileStat(accountFile.getAbsolutePath());
                if (accountFileStat.nlink() == 2) {
                    this.log.debug("Linked subject identifier {} to pool account file {}", (Object)subjectIdentifier, (Object)accountFile.getName());
                    return accountFile.getName();
                }
                new File(subjectIdentifierFilePath).delete();
            }
            this.log.debug("Could not map to account {}", (Object)accountFile.getName());
        }
        this.log.warn("{} pool account is full. Impossible to map {}", (Object)accountNamePrefix, (Object)subjectIdentifier);
        return null;
    }

    protected String buildSubjectIdentifier(X500Principal subjectDN, String primaryGroupName, List<String> secondaryGroupNames) {
        StringBuilder identifier = new StringBuilder();
        try {
            String rfc2253Subject = subjectDN.getName();
            String openSSLSubject = OpensslNameUtils.convertFromRfc2253((String)rfc2253Subject, (boolean)false);
            String encodedId = this.encodeSubjectIdentifier(openSSLSubject);
            identifier.append(encodedId);
        }
        catch (URIException e) {
            throw new RuntimeException("Charset required to be supported by JVM but is not available", e);
        }
        if (primaryGroupName != null) {
            identifier.append(":").append(primaryGroupName);
        }
        if (this.useSecondaryGroupNamesForMapping_ && secondaryGroupNames != null && !secondaryGroupNames.isEmpty()) {
            for (String secondaryGroupName : secondaryGroupNames) {
                identifier.append(":").append(secondaryGroupName);
            }
        }
        return identifier.toString();
    }

    protected String encodeSubjectIdentifier(String unescaped) throws URIException {
        String encoded = URIUtil.encode((String)unescaped, (BitSet)ALPHANUM);
        return encoded.toLowerCase();
    }

    protected String buildSubjectIdentifierFilePath(String subjectIdentifier) {
        return this.gridMapDirectory_.getAbsolutePath() + File.separator + subjectIdentifier;
    }

    private File[] getAccountFiles(final String prefix) {
        return this.gridMapDirectory_.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                Matcher nameMatcher = GridMapDirPoolAccountManager.this.poolAccountNamePattern_.matcher(name);
                return nameMatcher.matches() && (prefix == null || prefix.equals(nameMatcher.group(1)));
            }
        });
    }

    private String[] getAccountFileNames(final String prefix) {
        return this.gridMapDirectory_.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                Matcher nameMatcher = GridMapDirPoolAccountManager.this.poolAccountNamePattern_.matcher(name);
                return nameMatcher.matches() && (prefix == null || prefix.equals(nameMatcher.group(1)));
            }
        });
    }

    protected void setUseSecondaryGroupNamesForMapping(boolean useSecondaryGroupNamesForMapping) {
        this.useSecondaryGroupNamesForMapping_ = useSecondaryGroupNamesForMapping;
    }

    static {
        int i;
        ALPHANUM = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            ALPHANUM.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            ALPHANUM.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            ALPHANUM.set(i);
        }
    }
}

