/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.dfpmap;

import java.text.ParseException;
import org.glite.authz.common.fqan.FQAN;
import org.glite.authz.pep.obligation.dfpmap.DFPMMatchStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FQANMatchStrategy
implements DFPMMatchStrategy<FQAN> {
    private final Logger log = LoggerFactory.getLogger(FQANMatchStrategy.class);

    @Override
    public boolean isMatch(String dfpmKey, FQAN candidate) {
        boolean regexpMatches = false;
        try {
            regexpMatches = candidate.matches(dfpmKey);
        }
        catch (ParseException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("'{}' matches '{}' ? {}", new Object[]{candidate, dfpmKey, regexpMatches});
        }
        return regexpMatches;
    }
}

