/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.dfpmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.glite.authz.common.fqan.FQAN;
import org.glite.authz.pep.obligation.ObligationProcessingException;
import org.glite.authz.pep.obligation.dfpmap.DFPM;
import org.glite.authz.pep.obligation.dfpmap.DFPMMatchStrategy;
import org.glite.authz.pep.obligation.dfpmap.GroupNameMappingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FQANGroupNameMappingStrategy
implements GroupNameMappingStrategy {
    private final Logger log = LoggerFactory.getLogger(FQANGroupNameMappingStrategy.class);
    private DFPM groupNameMapping;
    private DFPMMatchStrategy<FQAN> fqanMatchStrategy;

    public FQANGroupNameMappingStrategy(DFPM mappings, DFPMMatchStrategy<FQAN> fqanMatching) {
        if (mappings == null) {
            throw new IllegalArgumentException("DN/FQAN to POSIX mapping may not be null");
        }
        this.groupNameMapping = mappings;
        if (fqanMatching == null) {
            throw new IllegalArgumentException("FQAN matching strategy may not be null");
        }
        this.fqanMatchStrategy = fqanMatching;
    }

    @Override
    public List<String> mapToGroupNames(X500Principal subjectDN, FQAN primaryFQAN, List<FQAN> secondaryFQANs) throws ObligationProcessingException {
        this.log.debug("Starting to map subject {} with primary FQAN {} and second FQANs {} to group names", new Object[]{subjectDN.getName("RFC2253"), primaryFQAN, secondaryFQANs});
        if (primaryFQAN == null) {
            this.log.error("Primary FQAN for subject " + subjectDN.getName() + " is null, group mapping can not be performed");
            throw new ObligationProcessingException("Primary FQAN is null, group mapping can not be performed");
        }
        ArrayList<String> groups = new ArrayList<String>();
        String firstGroupFromFQAN = null;
        for (String mapKey : this.groupNameMapping.keySet()) {
            if (!this.groupNameMapping.isFQANMapEntry(mapKey)) continue;
            if (firstGroupFromFQAN == null && this.fqanMatchStrategy.isMatch(mapKey, primaryFQAN)) {
                firstGroupFromFQAN = (String)((List)this.groupNameMapping.get(mapKey)).get(0);
            }
            if (secondaryFQANs == null) continue;
            for (FQAN secondaryFQAN : secondaryFQANs) {
                if (!this.fqanMatchStrategy.isMatch(mapKey, secondaryFQAN)) continue;
                groups.addAll((Collection)this.groupNameMapping.get(mapKey));
            }
        }
        if (firstGroupFromFQAN == null) {
            throw new ObligationProcessingException("Subject " + subjectDN.getName("RFC2253") + " could not be mapped to a primary group");
        }
        groups.add(0, firstGroupFromFQAN);
        this.removeDuplicates(groups);
        this.log.debug("Subject {} with primary FQAN {} and second FQANs {} mapped to group names {}", new Object[]{subjectDN.getName("RFC2253"), primaryFQAN, secondaryFQANs, groups});
        return groups;
    }

    private void removeDuplicates(List<String> groupNames) {
        HashSet<String> alreadySeen = new HashSet<String>();
        Iterator<String> nameItr = groupNames.iterator();
        while (nameItr.hasNext()) {
            String name = nameItr.next();
            if (alreadySeen.contains(name)) {
                nameItr.remove();
                continue;
            }
            alreadySeen.add(name);
        }
    }
}

