/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.dfpmap;

import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.glite.authz.common.fqan.FQAN;
import org.glite.authz.pep.obligation.ObligationProcessingException;
import org.glite.authz.pep.obligation.dfpmap.AccountIndicatorMappingStrategy;
import org.glite.authz.pep.obligation.dfpmap.DFPM;
import org.glite.authz.pep.obligation.dfpmap.DFPMMatchStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNPrimaryFQANAccountIndicatorMappingStrategy
implements AccountIndicatorMappingStrategy {
    private final Logger log = LoggerFactory.getLogger(DNPrimaryFQANAccountIndicatorMappingStrategy.class);
    private DFPM loginNameMapping;
    private DFPMMatchStrategy<X500Principal> dnMatchStrategy;
    private DFPMMatchStrategy<FQAN> fqanMatchStrategy;
    private boolean preferDNforAccountIndicator;

    public DNPrimaryFQANAccountIndicatorMappingStrategy(DFPM accountMappings, DFPMMatchStrategy<X500Principal> dnMatching, DFPMMatchStrategy<FQAN> fqanMatching, boolean preferDNmappings) {
        if (accountMappings == null) {
            throw new IllegalArgumentException("DN/FQAN to POSIX account mapping may not be null");
        }
        this.loginNameMapping = accountMappings;
        if (dnMatching == null) {
            throw new IllegalArgumentException("DN matching strategy may not be null");
        }
        this.dnMatchStrategy = dnMatching;
        if (fqanMatching == null) {
            throw new IllegalArgumentException("FQAN matching strategy may not be null");
        }
        this.fqanMatchStrategy = fqanMatching;
        this.preferDNforAccountIndicator = preferDNmappings;
    }

    @Override
    public String mapToAccountIndicator(X500Principal subjectDN, FQAN primaryFQAN, List<FQAN> secondaryFQANs) throws ObligationProcessingException {
        this.log.debug("Mapping account indicator for subject {} with primary FQAN {}", (Object)subjectDN, (Object)primaryFQAN);
        String indicatorFromDN = null;
        String indicatorFromFQAN = null;
        for (String mapKey : this.loginNameMapping.keySet()) {
            if (indicatorFromDN == null && this.loginNameMapping.isDNMapEntry(mapKey) && this.dnMatchStrategy.isMatch(mapKey, subjectDN)) {
                indicatorFromDN = (String)((List)this.loginNameMapping.get(mapKey)).get(0);
                if (this.preferDNforAccountIndicator) break;
            }
            if (primaryFQAN == null || indicatorFromFQAN != null || !this.loginNameMapping.isFQANMapEntry(mapKey) || !this.fqanMatchStrategy.isMatch(mapKey, primaryFQAN)) continue;
            indicatorFromFQAN = (String)((List)this.loginNameMapping.get(mapKey)).get(0);
            if (this.preferDNforAccountIndicator) continue;
            break;
        }
        String accountIndicator = this.preferDNforAccountIndicator ? (indicatorFromDN != null ? indicatorFromDN : indicatorFromFQAN) : (indicatorFromFQAN != null ? indicatorFromFQAN : indicatorFromDN);
        this.log.debug("Subject {} with primary FQAN {} mapped to account indicator {}", new Object[]{subjectDN, primaryFQAN, accountIndicator});
        return accountIndicator;
    }
}

