/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.dfpmap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.glite.authz.common.fqan.FQAN;
import org.glite.authz.pep.obligation.ObligationProcessingException;
import org.glite.authz.pep.obligation.dfpmap.DFPM;
import org.glite.authz.pep.obligation.dfpmap.DFPMMatchStrategy;
import org.glite.authz.pep.obligation.dfpmap.GroupNameMappingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNFQANGroupNameMappingStrategy
implements GroupNameMappingStrategy {
    private final Logger log = LoggerFactory.getLogger(DNFQANGroupNameMappingStrategy.class);
    private DFPM groupNameMapping;
    private DFPMMatchStrategy<FQAN> fqanMatchStrategy;
    private DFPMMatchStrategy<X500Principal> dnMatchStrategy;
    private boolean preferDNForPrimaryGroupName;

    public DNFQANGroupNameMappingStrategy(DFPM groupMappings, DFPMMatchStrategy<X500Principal> dnMatching, DFPMMatchStrategy<FQAN> fqanMatching, boolean preferDNmappings) {
        if (groupMappings == null) {
            throw new IllegalArgumentException("DN/FQAN to POSIX group mapping may not be null");
        }
        this.groupNameMapping = groupMappings;
        if (dnMatching == null) {
            throw new IllegalArgumentException("DN matching strategy may not be null");
        }
        this.dnMatchStrategy = dnMatching;
        if (fqanMatching == null) {
            throw new IllegalArgumentException("FQAN matching strategy may not be null");
        }
        this.fqanMatchStrategy = fqanMatching;
        this.preferDNForPrimaryGroupName = preferDNmappings;
    }

    @Override
    public List<String> mapToGroupNames(X500Principal subjectDN, FQAN primaryFQAN, List<FQAN> secondaryFQANs) throws ObligationProcessingException {
        this.log.debug("Mapping group names for subject {} with primary FQAN {} and secondary FQANs {}", new Object[]{subjectDN.getName(), primaryFQAN, secondaryFQANs});
        ArrayList dnGroupNames = new ArrayList();
        ArrayList fqanGroupNames = new ArrayList();
        for (String mapKey : this.groupNameMapping.keySet()) {
            List grNames;
            if (this.groupNameMapping.isDNMapEntry(mapKey)) {
                if (subjectDN == null || !this.dnMatchStrategy.isMatch(mapKey, subjectDN)) continue;
                grNames = (List)this.groupNameMapping.get(mapKey);
                dnGroupNames.addAll(grNames);
                continue;
            }
            if (!this.groupNameMapping.isFQANMapEntry(mapKey) || primaryFQAN == null || !this.fqanMatchStrategy.isMatch(mapKey, primaryFQAN)) continue;
            grNames = (List)this.groupNameMapping.get(mapKey);
            fqanGroupNames.addAll(grNames);
        }
        for (String mapKey : this.groupNameMapping.keySet()) {
            if (!this.groupNameMapping.isFQANMapEntry(mapKey) || secondaryFQANs == null) continue;
            for (FQAN secondaryFQAN : secondaryFQANs) {
                if (!this.fqanMatchStrategy.isMatch(mapKey, secondaryFQAN)) continue;
                List grNames = (List)this.groupNameMapping.get(mapKey);
                fqanGroupNames.addAll(grNames);
            }
        }
        ArrayList<String> groupNames = new ArrayList<String>();
        if (this.log.isTraceEnabled()) {
            this.log.trace("DN groups: {} FQAN groups: {}", dnGroupNames, fqanGroupNames);
        }
        if (this.preferDNForPrimaryGroupName) {
            groupNames.addAll(dnGroupNames);
            groupNames.addAll(fqanGroupNames);
        } else {
            groupNames.addAll(fqanGroupNames);
            groupNames.addAll(dnGroupNames);
        }
        this.removeDuplicates(groupNames);
        this.log.debug("Subject {} with primary FQAN {} and secondary FQANs {} mapped to group names: {}", new Object[]{subjectDN.getName(), primaryFQAN, secondaryFQANs, groupNames});
        return groupNames;
    }

    private void removeDuplicates(List<String> groupNames) {
        HashSet<String> alreadySeen = new HashSet<String>();
        Iterator<String> nameItr = groupNames.iterator();
        while (nameItr.hasNext()) {
            String name = nameItr.next();
            if (alreadySeen.contains(name)) {
                nameItr.remove();
                continue;
            }
            alreadySeen.add(name);
        }
    }
}

