/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.dfpmap;

import java.io.File;
import org.glite.authz.common.config.AbstractConfigurationBuilder;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.IniConfigUtil;
import org.glite.authz.common.config.IniSectionConfigurationParser;
import org.glite.authz.pep.obligation.ObligationHandler;
import org.glite.authz.pep.obligation.dfpmap.AccountMapper;
import org.glite.authz.pep.obligation.dfpmap.DFPM;
import org.glite.authz.pep.obligation.dfpmap.DFPMObligationHandler;
import org.glite.authz.pep.obligation.dfpmap.DNFQANGroupNameMappingStrategy;
import org.glite.authz.pep.obligation.dfpmap.DNPrimaryFQANAccountIndicatorMappingStrategy;
import org.glite.authz.pep.obligation.dfpmap.FQANMatchStrategy;
import org.glite.authz.pep.obligation.dfpmap.GridMapDirPoolAccountManager;
import org.glite.authz.pep.obligation.dfpmap.OrderedDFPM;
import org.glite.authz.pep.obligation.dfpmap.PoolAccountManager;
import org.glite.authz.pep.obligation.dfpmap.UpdatingDFPM;
import org.glite.authz.pep.obligation.dfpmap.X509MatchStrategy;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFPMObligationHandlerConfigurationParser
implements IniSectionConfigurationParser<ObligationHandler> {
    public static final String HANDLED_OBLIGATION_ID_PROP = "handledObligationId";
    public static final String HANDLED_OBLIGATION_ID_DEFAULT = "http://glite.org/xacml/obligation/local-environment-map";
    public static final String ACCOUNT_MAP_FILE_PROP = "accountMapFile";
    public static final String PREFER_DN_FOR_LOGIN_NAME_PROP = "preferDNForLoginName";
    public static final String PREFER_DN_FOR_PRIMARY_GROUP_NAME_PROP = "preferDNForPrimaryGroupName";
    public static final String NO_PRIMARY_GROUP_NAME_IS_ERROR_PROP = "noPrimaryGroupNameIsError";
    public static final String GROUP_MAP_FILE_PROP = "groupMapFile";
    public static final String MAP_REFRESH_PERIOD_PROP = "refreshPeriod";
    public static final String GRID_MAP_DIR_PROP = "gridMapDir";
    public static final boolean PREFER_DN_FOR_LOGIN_NAME_DEFAULT = true;
    public static final boolean PREFER_DN_FOR_PRIMARY_GOURP_NAME_DEFAULT = true;
    public static final boolean NO_PRIMARY_GROUP_NAME_IS_ERROR_DEFAULT = false;
    public static final int PRECENDENCE_DEFAULT = 0;
    public static final int MAP_REFRESH_PERIOD_DEFAULT = 15;
    public static final String REQUIRE_SUBJECT_KEYINFO_PROP = "requireSubjectKeyInfo";
    public static final boolean REQUIRE_SUBJECT_KEYINFO_DEFAULT = true;
    public static final String USE_SECONDARY_GROUP_NAMES_FOR_MAPPING_PROP = "useSecondaryGroupNamesForMapping";
    public static final boolean USE_SECONDARY_GROUP_NAMES_FOR_MAPPING_DEFAULT = true;
    private final Logger log = LoggerFactory.getLogger(DFPMObligationHandlerConfigurationParser.class);

    public ObligationHandler parse(Profile.Section iniConfig, AbstractConfigurationBuilder<?> configBuilder) throws ConfigurationException {
        String name = iniConfig.getName();
        String obligationId = IniConfigUtil.getString((Profile.Section)iniConfig, (String)HANDLED_OBLIGATION_ID_PROP, (String)HANDLED_OBLIGATION_ID_DEFAULT);
        this.log.info("{}: handled obligationID: {}", (Object)name, (Object)obligationId);
        String accountMapFile = IniConfigUtil.getString((Profile.Section)iniConfig, (String)ACCOUNT_MAP_FILE_PROP);
        this.log.info("{}: user mapping file: {}", (Object)name, (Object)accountMapFile);
        String groupMapFile = IniConfigUtil.getString((Profile.Section)iniConfig, (String)GROUP_MAP_FILE_PROP);
        this.log.info("{}: group mapping file: {}", (Object)name, (Object)groupMapFile);
        int mapRefreshPeriod = IniConfigUtil.getInt((Profile.Section)iniConfig, (String)MAP_REFRESH_PERIOD_PROP, (int)15, (int)1, (int)Integer.MAX_VALUE);
        this.log.info("{}: mapping file(s) refresh period: {} mins", (Object)name, (Object)mapRefreshPeriod);
        boolean preferDNForLoginName = IniConfigUtil.getBoolean((Profile.Section)iniConfig, (String)PREFER_DN_FOR_LOGIN_NAME_PROP, (boolean)true);
        this.log.info("{}: prefer DN login name mappings: {}", (Object)name, (Object)preferDNForLoginName);
        boolean preferDNForPrimaryGroupName = IniConfigUtil.getBoolean((Profile.Section)iniConfig, (String)PREFER_DN_FOR_PRIMARY_GROUP_NAME_PROP, (boolean)true);
        this.log.info("{}: prefer DN primary group mappings: {}", (Object)name, (Object)preferDNForPrimaryGroupName);
        String gridMapDir = IniConfigUtil.getString((Profile.Section)iniConfig, (String)GRID_MAP_DIR_PROP);
        this.log.info("{}: grid mapping directory: {}", (Object)name, (Object)gridMapDir);
        boolean noPrimaryGroupNameIsError = IniConfigUtil.getBoolean((Profile.Section)iniConfig, (String)NO_PRIMARY_GROUP_NAME_IS_ERROR_PROP, (boolean)false);
        this.log.info("{}: no primary group name mapping is error: {}", (Object)name, (Object)noPrimaryGroupNameIsError);
        boolean useSecondaryGroupNamesForMapping = IniConfigUtil.getBoolean((Profile.Section)iniConfig, (String)USE_SECONDARY_GROUP_NAMES_FOR_MAPPING_PROP, (boolean)true);
        this.log.info("{}: use secondary group names for mapping (lease filename): {}", (Object)name, (Object)useSecondaryGroupNamesForMapping);
        AccountMapper accountMapper = this.buildAccountMapper(accountMapFile, preferDNForLoginName, groupMapFile, preferDNForPrimaryGroupName, mapRefreshPeriod * 60 * 1000, gridMapDir, noPrimaryGroupNameIsError, useSecondaryGroupNamesForMapping);
        DFPMObligationHandler obligationHandler = new DFPMObligationHandler(name, obligationId, accountMapper);
        boolean requireSubjectKeyInfo = IniConfigUtil.getBoolean((Profile.Section)iniConfig, (String)REQUIRE_SUBJECT_KEYINFO_PROP, (boolean)true);
        this.log.info("{}: requires subject key-info attribute to apply: {}", (Object)name, (Object)requireSubjectKeyInfo);
        obligationHandler.setRequireSubjectKeyInfo(requireSubjectKeyInfo);
        return obligationHandler;
    }

    private AccountMapper buildAccountMapper(String accountMapFile, boolean preferDNMappingForAccountIndicator, String groupMapFile, boolean preferDNMappingForPrimaryGroupName, int mapRefreshPeriod, String gridMapDir, boolean noPrimaryGroupNameIsError, boolean useSecondaryGroupNamesForMapping) throws ConfigurationException {
        X509MatchStrategy dnMatchStrategy = new X509MatchStrategy();
        FQANMatchStrategy fqanMatchStrategy = new FQANMatchStrategy();
        DFPM accountIndicatorMap = this.buildMapping(accountMapFile, mapRefreshPeriod);
        DFPM groupMap = this.buildMapping(groupMapFile, mapRefreshPeriod);
        PoolAccountManager poolAccountManager = this.buildPoolAccountManager(gridMapDir, useSecondaryGroupNamesForMapping);
        DNPrimaryFQANAccountIndicatorMappingStrategy aimStrategy = new DNPrimaryFQANAccountIndicatorMappingStrategy(accountIndicatorMap, dnMatchStrategy, fqanMatchStrategy, preferDNMappingForAccountIndicator);
        DNFQANGroupNameMappingStrategy gnmStrategy = new DNFQANGroupNameMappingStrategy(groupMap, dnMatchStrategy, fqanMatchStrategy, preferDNMappingForPrimaryGroupName);
        return new AccountMapper(aimStrategy, gnmStrategy, poolAccountManager, noPrimaryGroupNameIsError);
    }

    private DFPM buildMapping(String mappingFilePath, int refreshPeriod) throws ConfigurationException {
        UpdatingDFPM.DFPMFactory dfpmFactory = new UpdatingDFPM.DFPMFactory(){

            public DFPM newInstance() {
                return new OrderedDFPM();
            }
        };
        return new UpdatingDFPM(dfpmFactory, mappingFilePath, refreshPeriod);
    }

    private PoolAccountManager buildPoolAccountManager(String gridMapDirPath, boolean useSecondaryGroupNamesForMapping) throws ConfigurationException {
        File gridMapDir = new File(gridMapDirPath);
        if (!gridMapDir.exists()) {
            String errMsg = MessageFormatter.format((String)"Grid map directory {} does not exist", (Object)gridMapDir.getAbsolutePath());
            this.log.error(errMsg);
            throw new ConfigurationException(errMsg);
        }
        if (!gridMapDir.canRead()) {
            String errMsg = MessageFormatter.format((String)"Grid map directory {} is not readable by this process", (Object)gridMapDir.getAbsolutePath());
            this.log.error(errMsg);
            throw new ConfigurationException(errMsg);
        }
        if (!gridMapDir.canWrite()) {
            String errMsg = MessageFormatter.format((String)"Grid map directory {} is not writable by this process", (Object)gridMapDir.getAbsolutePath());
            this.log.error(errMsg);
            throw new ConfigurationException(errMsg);
        }
        GridMapDirPoolAccountManager poolAccountManager = new GridMapDirPoolAccountManager(gridMapDir, useSecondaryGroupNamesForMapping);
        return poolAccountManager;
    }
}

