/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.dfpmap;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.glite.authz.common.fqan.FQAN;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.AttributeAssignment;
import org.glite.authz.common.model.Obligation;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Result;
import org.glite.authz.common.model.Subject;
import org.glite.authz.pep.obligation.AbstractObligationHandler;
import org.glite.authz.pep.obligation.ObligationProcessingException;
import org.glite.authz.pep.obligation.dfpmap.AccountMapper;
import org.glite.authz.pep.obligation.dfpmap.PosixAccount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFPMObligationHandler
extends AbstractObligationHandler {
    private final Logger log = LoggerFactory.getLogger(DFPMObligationHandler.class);
    private AccountMapper accountMapper;
    private boolean requireSubjectKeyInfo = true;

    public DFPMObligationHandler(String name, String obligationId, AccountMapper mapper) {
        super(name, obligationId);
        if (mapper == null) {
            throw new IllegalArgumentException("Account mapper may not be null");
        }
        this.accountMapper = mapper;
    }

    public DFPMObligationHandler(String name, AccountMapper mapper) {
        this(name, "http://glite.org/xacml/obligation/local-environment-map", mapper);
    }

    public DFPMObligationHandler(String name, int precedence, AccountMapper mapper) {
        this(name, "http://glite.org/xacml/obligation/local-environment-map", mapper);
        this.setHanderPrecedence(precedence);
    }

    public boolean evaluateObligation(Request request, Result result) throws ObligationProcessingException {
        List<FQAN> secondaryFQANs;
        FQAN primaryFQAN;
        boolean applied = false;
        Subject subject = this.getSubject(request);
        if (this.requireSubjectKeyInfo && !this.subjectContainsKeyInfo(subject)) {
            this.log.info("{}: Does not apply. Requires a request subject key-info attribute, but none found.", (Object)this.getId());
            return false;
        }
        X500Principal subjectDN = this.getDN(subject);
        PosixAccount mappedAccount = this.accountMapper.mapToAccount(subjectDN, primaryFQAN = this.getPrimaryFQAN(subject), secondaryFQANs = this.getSecondaryFQANs(subject));
        if (mappedAccount != null) {
            this.addPosixMappingObligation(result, mappedAccount);
            applied = true;
            Iterator obligationItr = result.getObligations().iterator();
            ArrayList<Obligation> removedObligations = new ArrayList<Obligation>();
            while (obligationItr.hasNext()) {
                Obligation obligation = (Obligation)obligationItr.next();
                if (!this.getObligationId().equals(obligation.getId())) continue;
                removedObligations.add(obligation);
            }
            result.getObligations().removeAll(removedObligations);
            this.log.info("{}: DN: {} pFQAN: {} FQANs: {} mapped to POSIX account: {}", new Object[]{this.getId(), subjectDN.getName("RFC2253"), primaryFQAN, secondaryFQANs, mappedAccount});
        }
        this.log.debug("Finished processing DN/FQAN to POSIX account mapping obligation for subject {}", (Object)subjectDN.getName());
        return applied;
    }

    private Subject getSubject(Request request) throws ObligationProcessingException {
        Set subjects = request.getSubjects();
        if (subjects == null || subjects.isEmpty()) {
            throw new ObligationProcessingException("Unable to process request, it does not contain a subject");
        }
        if (subjects.size() != 1) {
            this.log.warn("Request contains '{}' subject, unable to process it", (Object)subjects.size());
            throw new ObligationProcessingException("Requests contains more than one subject");
        }
        return (Subject)subjects.iterator().next();
    }

    private boolean subjectContainsKeyInfo(Subject subject) {
        Set attributes = subject.getAttributes();
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                if (!"urn:oasis:names:tc:xacml:1.0:subject:key-info".equals(attribute.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private X500Principal getDN(Subject subject) throws ObligationProcessingException {
        Attribute dnAttribute = null;
        for (Attribute attribute : subject.getAttributes()) {
            if (!"urn:oasis:names:tc:xacml:1.0:subject:subject-id".equals(attribute.getId()) || !"urn:oasis:names:tc:xacml:1.0:data-type:x500Name".equals(attribute.getDataType())) continue;
            this.log.debug("Extracted subject attribute from request: {}", (Object)attribute);
            dnAttribute = attribute;
            break;
        }
        if (dnAttribute == null) {
            this.log.error("Subject of the authorization request did not contain a subject ID attribute {} datatype {}", (Object)"urn:oasis:names:tc:xacml:1.0:subject:subject-id", (Object)"urn:oasis:names:tc:xacml:1.0:data-type:x500Name");
            throw new ObligationProcessingException("Invalid request, missing subject attribute: urn:oasis:names:tc:xacml:1.0:subject:subject-id datatype: urn:oasis:names:tc:xacml:1.0:data-type:x500Name");
        }
        Set values = dnAttribute.getValues();
        if (values == null || values.isEmpty()) {
            this.log.error("Subject ID attribute of the authorization request did not contain any values");
            throw new ObligationProcessingException("Invalid request, subject attribute did not contain any values");
        }
        if (values.size() > 1) {
            this.log.warn("Subject ID attribute contains more than one value, only the first will be used");
        }
        try {
            String subjectDN = values.iterator().next().toString();
            return new X500Principal(subjectDN);
        }
        catch (IllegalArgumentException e) {
            this.log.error("Value of the Subject ID attribute of the authorization request was not a valid X.509 DN");
            throw new ObligationProcessingException("Invalid request, value of the Subject ID attribute was not a valid X.509 DN");
        }
    }

    protected void setRequireSubjectKeyInfo(boolean requireSubjectKeyInfo) {
        this.requireSubjectKeyInfo = requireSubjectKeyInfo;
    }

    private FQAN getPrimaryFQAN(Subject subject) throws ObligationProcessingException {
        Attribute primaryFQANAttribute = null;
        for (Attribute attribute : subject.getAttributes()) {
            if (!"http://glite.org/xacml/attribute/fqan/primary".equals(attribute.getId())) continue;
            this.log.debug("Extracted primary FQAN attribute from request: {}", (Object)attribute);
            primaryFQANAttribute = attribute;
            break;
        }
        if (primaryFQANAttribute == null) {
            this.log.debug("Subject of the authorization request did not contain a subject primary FQAN attribute");
            return null;
        }
        if (!"http://glite.org/xacml/datatype/fqan".equals(primaryFQANAttribute.getDataType())) {
            this.log.error("Subject primary FQAN attribute of the authorization request was of the incorrect data type: {}", (Object)primaryFQANAttribute.getDataType());
            throw new ObligationProcessingException("Invalid request, subject attribute of invalid data type");
        }
        Set values = primaryFQANAttribute.getValues();
        if (values == null || values.isEmpty()) {
            this.log.error("Subject primary FQAN attribute of the authorization request did not contain any values");
            throw new ObligationProcessingException("Invalid request, subject attribute did not contain any values");
        }
        if (values.size() > 1) {
            this.log.warn("Primary FQAN attribute contains more than one value, only the first will be used");
        }
        try {
            return FQAN.parseFQAN((String)values.iterator().next().toString());
        }
        catch (ParseException e) {
            this.log.error("Value of the Subject primary FQAN attribute of the authorization request was not a valid FQAN", (Throwable)e);
            throw new ObligationProcessingException("Invalid request, subject's primary FQAN attribute value was invalid", (Exception)e);
        }
    }

    private List<FQAN> getSecondaryFQANs(Subject subject) throws ObligationProcessingException {
        Attribute secondaryFQANsAttribute = null;
        for (Attribute attribute : subject.getAttributes()) {
            if (!"http://glite.org/xacml/attribute/fqan".equals(attribute.getId())) continue;
            this.log.debug("Extracted secondary FQAN attribute from request: {}", (Object)attribute);
            secondaryFQANsAttribute = attribute;
            break;
        }
        if (secondaryFQANsAttribute == null) {
            this.log.debug("Subject of the authorization request did not contain a subject secondary FQAN attribute");
            return null;
        }
        if (!"http://glite.org/xacml/datatype/fqan".equals(secondaryFQANsAttribute.getDataType())) {
            this.log.error("Subject secondary FQAN attribute of the authorization request was of the incorrect data type: {}", (Object)secondaryFQANsAttribute.getDataType());
            throw new ObligationProcessingException("Invalid request, subject attribute of invalid data type");
        }
        Set values = secondaryFQANsAttribute.getValues();
        if (values == null || values.isEmpty()) {
            this.log.error("Subject secondary FQAN attribute of the authorization request did not contain any values");
            throw new ObligationProcessingException("Invalid request, subject attribute did not contain any values");
        }
        if (values.size() > 1) {
            this.log.warn("Secondary FQAN attribute contains more than one value, only the first will be used");
        }
        ArrayList<FQAN> secondaryFQANs = new ArrayList<FQAN>();
        Iterator valueItr = values.iterator();
        String value = null;
        while (valueItr.hasNext()) {
            try {
                value = valueItr.next().toString();
                FQAN parsedFQAN = FQAN.parseFQAN((String)value);
                secondaryFQANs.add(parsedFQAN);
            }
            catch (ParseException e) {
                this.log.error("Subject's secondary FQAN attribute value " + value + " is not a valid FQAN");
                throw new ObligationProcessingException("Invalid request, subject's secondary FQAN attribute value was invalid");
            }
        }
        return secondaryFQANs;
    }

    protected void addPosixMappingObligation(Result result, PosixAccount account) {
        AttributeAssignment secondaryGroupId;
        Obligation posixMapping = new Obligation();
        posixMapping.setId("http://glite.org/xacml/obligation/local-environment-map/posix");
        posixMapping.setFulfillOn(1);
        AttributeAssignment userid = new AttributeAssignment();
        userid.setAttributeId("http://glite.org/xacml/attribute/user-id");
        userid.setDataType("http://www.w3.org/2001/XMLSchema#string");
        userid.setValue(account.getLoginName());
        posixMapping.getAttributeAssignments().add(userid);
        if (account.getPrimaryGroup() != null) {
            String groupId = account.getPrimaryGroup();
            AttributeAssignment primaryGroupId = new AttributeAssignment();
            primaryGroupId.setAttributeId("http://glite.org/xacml/attribute/group-id/primary");
            primaryGroupId.setDataType("http://www.w3.org/2001/XMLSchema#string");
            primaryGroupId.setValue(groupId);
            posixMapping.getAttributeAssignments().add(primaryGroupId);
            secondaryGroupId = new AttributeAssignment();
            secondaryGroupId.setAttributeId("http://glite.org/xacml/attribute/group-id");
            secondaryGroupId.setDataType("http://www.w3.org/2001/XMLSchema#string");
            secondaryGroupId.setValue(groupId);
            posixMapping.getAttributeAssignments().add(secondaryGroupId);
        }
        if (account.getSecondaryGroups() != null && !account.getSecondaryGroups().isEmpty()) {
            for (String secondaryGroup : account.getSecondaryGroups()) {
                secondaryGroupId = new AttributeAssignment();
                secondaryGroupId.setAttributeId("http://glite.org/xacml/attribute/group-id");
                secondaryGroupId.setDataType("http://www.w3.org/2001/XMLSchema#string");
                secondaryGroupId.setValue(secondaryGroup);
                posixMapping.getAttributeAssignments().add(secondaryGroupId);
            }
        }
        result.getObligations().add(posixMapping);
    }
}

