/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.dfpmap;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.List;
import java.util.UnknownFormatConversionException;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.util.Strings;
import org.glite.authz.pep.obligation.dfpmap.DFPM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFPMFileParser {
    private final Logger log = LoggerFactory.getLogger(DFPMFileParser.class);

    public void parse(DFPM map, Reader mapFileReader) throws ConfigurationException {
        LineNumberReader reader = new LineNumberReader(mapFileReader);
        try {
            String line = reader.readLine();
            do {
                this.parseLine(map, line, reader.getLineNumber());
            } while ((line = reader.readLine()) != null);
        }
        catch (IOException e) {
            this.log.error("Unable to read map file", (Throwable)e);
            throw new ConfigurationException("Unable to read map file", (Exception)e);
        }
    }

    private void parseLine(DFPM map, String line, int lineNumber) throws ConfigurationException {
        List values;
        String trimmedLine = Strings.safeTrimOrNullString((String)line);
        if (trimmedLine == null || trimmedLine.startsWith("#")) {
            this.log.trace("Line number {} is a comment, no processing performed", (Object)lineNumber);
            return;
        }
        int lastDQuote = trimmedLine.lastIndexOf("\"");
        String unescapedKey = Strings.safeTrimOrNullString((String)trimmedLine.substring(1, lastDQuote));
        if (unescapedKey == null) {
            String msg = "Error on map file line " + lineNumber + ": Map file entry key may not be null or empty";
            this.log.error(msg);
            throw new ConfigurationException(msg);
        }
        String key = this.unescapeString(unescapedKey);
        if ((values = Strings.toList((String)trimmedLine.substring(++lastDQuote), (String)",")) == null || values.isEmpty()) {
            String msg = "Error on map file line " + lineNumber + ": Map file entry value may not be null or empty";
            this.log.error(msg);
            throw new ConfigurationException(msg);
        }
        this.log.debug("Line {}: maps {} to {}", new Object[]{lineNumber, key, values});
        map.put(key, values);
    }

    private String unescapeString(String string) throws UnknownFormatConversionException {
        char[] stringChars = string.toCharArray();
        StringBuilder unescapedString = new StringBuilder();
        block12: for (int i = 0; i < stringChars.length; ++i) {
            if (stringChars[i] != '\\') {
                unescapedString.append(stringChars[i]);
                continue;
            }
            switch (stringChars[i + 1]) {
                case 'b': {
                    unescapedString.append('\b');
                    ++i;
                    continue block12;
                }
                case 'f': {
                    unescapedString.append('\f');
                    ++i;
                    continue block12;
                }
                case 'n': {
                    unescapedString.append('\n');
                    ++i;
                    continue block12;
                }
                case 'r': {
                    unescapedString.append('\r');
                    ++i;
                    continue block12;
                }
                case 't': {
                    unescapedString.append('\t');
                    ++i;
                    continue block12;
                }
                case '\'': {
                    unescapedString.append('\'');
                    ++i;
                    continue block12;
                }
                case '\"': {
                    unescapedString.append('\"');
                    ++i;
                    continue block12;
                }
                case '\\': {
                    unescapedString.append('\\');
                    ++i;
                    continue block12;
                }
                case 'x': {
                    char[] hexChars = new char[]{stringChars[i + 2], stringChars[i + 3]};
                    unescapedString.append((char)Integer.parseInt(new String(hexChars), 16));
                    i += 3;
                    continue block12;
                }
                case 'u': {
                    char[] hexChars = new char[]{stringChars[i + 2], stringChars[i + 3], stringChars[i + 4], stringChars[i + 5]};
                    unescapedString.append((char)Integer.parseInt(new String(hexChars), 16));
                    i += 5;
                    continue block12;
                }
                default: {
                    throw new UnknownFormatConversionException("Escape sequence '\\" + stringChars[i + 1] + " in string '" + string + "' is not supported");
                }
            }
        }
        return unescapedString.toString().trim();
    }
}

