/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation.dfpmap;

import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.glite.authz.common.fqan.FQAN;
import org.glite.authz.pep.obligation.ObligationProcessingException;
import org.glite.authz.pep.obligation.dfpmap.AccountIndicatorMappingStrategy;
import org.glite.authz.pep.obligation.dfpmap.GroupNameMappingStrategy;
import org.glite.authz.pep.obligation.dfpmap.PoolAccountManager;
import org.glite.authz.pep.obligation.dfpmap.PosixAccount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountMapper {
    private final Logger log = LoggerFactory.getLogger(AccountMapper.class);
    private final AccountIndicatorMappingStrategy accountIndicatorMappingStrategy;
    private final GroupNameMappingStrategy groupNameMappingStrategy;
    private final PoolAccountManager poolAccountManager;
    private boolean noPrimaryGroupNameIsError = false;

    public AccountMapper(AccountIndicatorMappingStrategy aimStrategy, GroupNameMappingStrategy gnmStrategy, PoolAccountManager pam) {
        if (aimStrategy == null) {
            throw new IllegalArgumentException("Account indiciator mapping strategy may not be null");
        }
        this.accountIndicatorMappingStrategy = aimStrategy;
        if (gnmStrategy == null) {
            throw new IllegalArgumentException("Group name mapping strategy may not be null");
        }
        this.groupNameMappingStrategy = gnmStrategy;
        if (pam == null) {
            throw new IllegalArgumentException("Pool account manager may not be null");
        }
        this.poolAccountManager = pam;
    }

    public AccountMapper(AccountIndicatorMappingStrategy aimStrategy, GroupNameMappingStrategy gnmStrategy, PoolAccountManager pam, boolean noPrimaryGroupNameIsError) {
        this(aimStrategy, gnmStrategy, pam);
        this.noPrimaryGroupNameIsError = noPrimaryGroupNameIsError;
    }

    public PosixAccount mapToAccount(X500Principal subjectDN, FQAN primaryFQAN, List<FQAN> secondaryFQANs) throws ObligationProcessingException {
        if (subjectDN == null) {
            String error = "Can not map without Subject DN";
            this.log.error(error);
            throw new ObligationProcessingException(error);
        }
        return this.mapToAccountByDNFQAN(subjectDN, primaryFQAN, secondaryFQANs);
    }

    private PosixAccount mapToAccountByDNFQAN(X500Principal subjectDN, FQAN primaryFQAN, List<FQAN> secondaryFQANs) throws ObligationProcessingException {
        this.log.debug("Mapping subject {} with primary FQAN {} and secondary FQANs {} to a POSIX account", new Object[]{subjectDN, primaryFQAN, secondaryFQANs});
        String accountIndicator = this.accountIndicatorMappingStrategy.mapToAccountIndicator(subjectDN, primaryFQAN, secondaryFQANs);
        if (accountIndicator == null) {
            String error = "Failed to map subject DN " + subjectDN + ", primary FQAN " + primaryFQAN + ", secondary FQANs " + secondaryFQANs + " to an account indicator";
            this.log.error(error);
            throw new ObligationProcessingException(error);
        }
        boolean indicatorIsPoolAccountPrefix = false;
        if (this.poolAccountManager.isPoolAccountPrefix(accountIndicator)) {
            indicatorIsPoolAccountPrefix = true;
            accountIndicator = this.poolAccountManager.getPoolAccountPrefix(accountIndicator);
        }
        this.log.debug("Subject {} mapped to account indiciator {}", (Object)subjectDN.getName(), (Object)accountIndicator);
        String primaryGroupName = null;
        List<String> secondaryGroupNames = null;
        List<String> groupNames = this.groupNameMappingStrategy.mapToGroupNames(subjectDN, primaryFQAN, secondaryFQANs);
        if (groupNames != null && !groupNames.isEmpty()) {
            primaryGroupName = groupNames.get(0);
            secondaryGroupNames = groupNames.size() > 1 ? groupNames.subList(1, groupNames.size()) : Collections.emptyList();
        }
        if (primaryGroupName == null && this.noPrimaryGroupNameIsError) {
            String error = "Failed to map subject DN " + subjectDN.getName() + ", primary FQAN " + primaryFQAN + ", secondary FQANs " + secondaryFQANs + " to a POSIX primary group";
            this.log.error(error);
            throw new ObligationProcessingException(error);
        }
        this.log.debug("Subject {} mapped to POSIX group {} and secondary groups {}", new Object[]{subjectDN.getName(), primaryGroupName, secondaryGroupNames});
        String loginName = indicatorIsPoolAccountPrefix ? this.poolAccountManager.mapToAccount(accountIndicator, subjectDN, primaryGroupName, secondaryGroupNames) : accountIndicator;
        if (loginName == null) {
            String error = "Failed to map subject DN " + subjectDN.getName() + ", primary FQAN " + primaryFQAN + ", secondary FQANs " + secondaryFQANs + " to a POSIX login name";
            this.log.error(error);
            throw new ObligationProcessingException(error);
        }
        this.log.debug("Subject {} mapped to POSIX login name {}", (Object)subjectDN.getName(), (Object)loginName);
        return new PosixAccount(loginName, primaryGroupName, secondaryGroupNames);
    }
}

