/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.obligation;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.model.Obligation;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Result;
import org.glite.authz.pep.obligation.ObligationHandler;
import org.glite.authz.pep.obligation.ObligationProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ObligationService {
    private final Logger log = LoggerFactory.getLogger(ObligationService.class);
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private Set<ObligationHandler> obligationHandlers = new TreeSet<ObligationHandler>(new ObligationHandlerComparator());

    public Set<ObligationHandler> getObligationHandlers() {
        return Collections.unmodifiableSet(this.obligationHandlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObligationhandler(ObligationHandler handler) {
        if (handler == null) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            this.obligationHandlers.add(handler);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObligationhandlers(Collection<ObligationHandler> handlers) {
        if (handlers == null || handlers.isEmpty()) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            this.obligationHandlers.addAll(handlers);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObligationHandler(ObligationHandler handler) {
        if (handler == null) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            this.obligationHandlers.remove(handler);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processObligations(Request request, Result result) throws ObligationProcessingException {
        ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            Iterator<ObligationHandler> handlerItr = this.obligationHandlers.iterator();
            Map<String, Obligation> effectiveObligations = this.preprocessObligations(result);
            this.log.debug("Obligations in effect for this result: {}", effectiveObligations.keySet());
            while (handlerItr.hasNext()) {
                ObligationHandler handler = handlerItr.next();
                if (!effectiveObligations.containsKey(handler.getObligationId())) continue;
                this.log.debug("Processing obligation {}", (Object)handler.getObligationId());
                handler.evaluateObligation(request, result);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    protected Map<String, Obligation> preprocessObligations(Result result) {
        HashMap<String, Obligation> effectiveObligations = new HashMap<String, Obligation>();
        List obligations = result.getObligations();
        if (obligations == null || obligations.isEmpty()) {
            return effectiveObligations;
        }
        for (Obligation obligation : obligations) {
            if (obligation == null || obligation.getFulfillOn() != result.getDecision()) continue;
            effectiveObligations.put(obligation.getId(), obligation);
        }
        return effectiveObligations;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObligationHandlerComparator
    implements Comparator<ObligationHandler> {
        private ObligationHandlerComparator() {
        }

        @Override
        public int compare(ObligationHandler o1, ObligationHandler o2) {
            if (o1.getHandlerPrecedence() == o2.getHandlerPrecedence()) {
                return o1.getObligationId().compareTo(o2.getObligationId());
            }
            if (o1.getHandlerPrecedence() < o2.getHandlerPrecedence()) {
                return -1;
            }
            return 1;
        }
    }
}

